/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMComplexDoubleMul;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMComplexDoubleMul.class)
public final class LLVMComplexDoubleMulNodeGen
extends LLVMComplexDoubleMul {
    @Node.Child
    private LLVMExpressionNode result_;
    @Node.Child
    private LLVMExpressionNode a_;
    @Node.Child
    private LLVMExpressionNode b_;
    @Node.Child
    private LLVMExpressionNode c_;
    @Node.Child
    private LLVMExpressionNode d_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMComplexDoubleMulNodeGen(LLVMExpressionNode result, LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        this.result_ = result;
        this.a_ = a;
        this.b_ = b;
        this.c_ = c;
        this.d_ = d;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        double dValue_;
        double cValue_;
        double bValue_;
        double aValue_;
        int state_0 = this.state_0_;
        Object resultValue_ = this.result_.executeGeneric(frameValue);
        try {
            aValue_ = this.a_.executeDouble(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object bValue = this.b_.executeGeneric(frameValue);
            Object cValue = this.c_.executeGeneric(frameValue);
            Object dValue = this.d_.executeGeneric(frameValue);
            return this.executeAndSpecialize(resultValue_, ex.getResult(), bValue, cValue, dValue);
        }
        try {
            bValue_ = this.b_.executeDouble(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object cValue = this.c_.executeGeneric(frameValue);
            Object dValue = this.d_.executeGeneric(frameValue);
            return this.executeAndSpecialize(resultValue_, aValue_, ex.getResult(), cValue, dValue);
        }
        try {
            cValue_ = this.c_.executeDouble(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object dValue = this.d_.executeGeneric(frameValue);
            return this.executeAndSpecialize(resultValue_, aValue_, bValue_, ex.getResult(), dValue);
        }
        try {
            dValue_ = this.d_.executeDouble(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(resultValue_, aValue_, bValue_, cValue_, ex.getResult());
        }
        if (state_0 != 0 && LLVMTypes.isPointer(resultValue_)) {
            LLVMPointer resultValue__ = LLVMTypes.asPointer(resultValue_);
            return this.doDouble(resultValue__, aValue_, bValue_, cValue_, dValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(resultValue_, aValue_, bValue_, cValue_, dValue_);
    }

    private LLVMPointer executeAndSpecialize(Object resultValue, Object aValue, Object bValue, Object cValue, Object dValue) {
        int state_0 = this.state_0_;
        if (LLVMTypes.isPointer(resultValue)) {
            LLVMPointer resultValue_ = LLVMTypes.asPointer(resultValue);
            if (aValue instanceof Double) {
                double aValue_ = (Double)aValue;
                if (bValue instanceof Double) {
                    double bValue_ = (Double)bValue;
                    if (cValue instanceof Double) {
                        double cValue_ = (Double)cValue;
                        if (dValue instanceof Double) {
                            double dValue_ = (Double)dValue;
                            this.state_0_ = state_0 |= 1;
                            return this.doDouble(resultValue_, aValue_, bValue_, cValue_, dValue_);
                        }
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.result_, this.a_, this.b_, this.c_, this.d_}, new Object[]{resultValue, aValue, bValue, cValue, dValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMComplexDoubleMul create(LLVMExpressionNode result, LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        return new LLVMComplexDoubleMulNodeGen(result, a, b, c, d);
    }
}

