/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMTypeIDNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTypeIDNode
extends LLVMExpressionNode {
    @CompilerDirectives.CompilationFinal
    private LLVMInteropType cachedType;

    public static LLVMTypeIDNode create(LLVMExpressionNode child) {
        return LLVMTypeIDNodeGen.create(child);
    }

    protected final LLVMInteropType getType(TruffleLanguage.ContextReference<LLVMContext> ctxRef, LLVMPointer pointer) {
        LLVMContext context = (LLVMContext)ctxRef.get();
        if (this.cachedType == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            LLVMGlobal global = ((LLVMContext)ctxRef.get()).findGlobal(pointer);
            if (global == null) {
                return null;
            }
            this.cachedType = global.getInteropType(context);
        } else assert (context.findGlobal(pointer).getInteropType(context) == this.cachedType);
        return this.cachedType;
    }

    @Specialization
    LLVMInteropType doGlobal(LLVMPointer pointer, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
        LLVMInteropType type = this.getType(ctxRef, pointer);
        if (type instanceof LLVMInteropType.Array) {
            return ((LLVMInteropType.Array)type).elementType;
        }
        CompilerDirectives.transferToInterpreter();
        return this.fallback(pointer);
    }

    @Fallback
    LLVMInteropType.Structured fallback(Object typeid) {
        CompilerDirectives.transferToInterpreter();
        throw new LLVMPolyglotException(this, "Couldn't find runtime type information. Make sure the LLVM bitcode is compiled with debug information (-g).");
    }
}

