/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotWrite;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPolyglotWrite.class)
public final class LLVMPolyglotWriteFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=LLVMPolyglotWrite.LLVMPolyglotSetArrayElement.class)
    public static final class LLVMPolyglotSetArrayElementNodeGen
    extends LLVMPolyglotWrite.LLVMPolyglotSetArrayElement {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @Node.Child
        private LLVMExpressionNode child2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMAsForeignNode intrinsic_asForeign_;
        @Node.Child
        private InteropLibrary intrinsic_foreignWrite_;

        private LLVMPolyglotSetArrayElementNodeGen(Type[] argTypes, LLVMExpressionNode child0, LLVMExpressionNode child1, LLVMExpressionNode child2) {
            super(argTypes);
            this.child0_ = child0;
            this.child1_ = child1;
            this.child2_ = child2;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0 && state_0 != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0, VirtualFrame frameValue) {
            int child1Value_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object child2Value = this.child2_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), child2Value);
            }
            Object child2Value_ = this.child2_.executeGeneric(frameValue);
            assert ((state_0 & 1) != 0);
            if (LLVMTypes.isManagedPointer(child0Value_)) {
                LLVMManagedPointer child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
                return this.doIntrinsic(child0Value__, child1Value_, child2Value_, this.intrinsic_asForeign_, this.intrinsic_foreignWrite_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, child2Value_);
        }

        private Object executeGeneric_generic1(int state_0, VirtualFrame frameValue) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            Object child2Value_ = this.child2_.executeGeneric(frameValue);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(child0Value_)) {
                    LLVMManagedPointer child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
                    if (child1Value_ instanceof Integer) {
                        int child1Value__ = (Integer)child1Value_;
                        return this.doIntrinsic(child0Value__, child1Value__, child2Value_, this.intrinsic_asForeign_, this.intrinsic_foreignWrite_);
                    }
                }
                if ((state_0 & 2) != 0 && LLVMPolyglotSetArrayElementNodeGen.fallbackGuard_(state_0, child0Value_, child1Value_, child2Value_)) {
                    return this.fallback(child0Value_, child1Value_, child2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, child2Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, Object child2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (LLVMTypes.isManagedPointer(child0Value)) {
                    LLVMManagedPointer child0Value_ = LLVMTypes.asManagedPointer(child0Value);
                    if (child1Value instanceof Integer) {
                        int child1Value_ = (Integer)child1Value;
                        this.intrinsic_asForeign_ = (LLVMAsForeignNode)super.insert((Node)LLVMAsForeignNode.create());
                        this.intrinsic_foreignWrite_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doIntrinsic(child0Value_, child1Value_, child2Value, this.intrinsic_asForeign_, this.intrinsic_foreignWrite_);
                        return object;
                    }
                }
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.fallback(child0Value, child1Value, child2Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value, Object child2Value) {
            return (state_0 & 1) != 0 || !LLVMTypes.isManagedPointer(child0Value) || !(child1Value instanceof Integer);
        }

        public static LLVMPolyglotWrite.LLVMPolyglotSetArrayElement create(Type[] argTypes, LLVMExpressionNode child0, LLVMExpressionNode child1, LLVMExpressionNode child2) {
            return new LLVMPolyglotSetArrayElementNodeGen(argTypes, child0, child1, child2);
        }
    }

    @GeneratedBy(value=LLVMPolyglotWrite.LLVMPolyglotPutMember.class)
    public static final class LLVMPolyglotPutMemberNodeGen
    extends LLVMPolyglotWrite.LLVMPolyglotPutMember {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @Node.Child
        private LLVMExpressionNode child2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private IntrinsicData intrinsic_cache;

        private LLVMPolyglotPutMemberNodeGen(Type[] argTypes, LLVMExpressionNode child0, LLVMExpressionNode child1, LLVMExpressionNode child2) {
            super(argTypes);
            this.child0_ = child0;
            this.child1_ = child1;
            this.child2_ = child2;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            Object child2Value_ = this.child2_.executeGeneric(frameValue);
            if ((state_0 & 2) != 0 && LLVMPolyglotPutMemberNodeGen.fallbackGuard_(state_0, child0Value_, child1Value_, child2Value_)) {
                return this.fallback(child0Value_, child1Value_, child2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, child2Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object child0Value, Object child1Value, Object child2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (LLVMTypes.isManagedPointer(child0Value)) {
                    LLVMManagedPointer child0Value_ = LLVMTypes.asManagedPointer(child0Value);
                    IntrinsicData s1_ = (IntrinsicData)super.insert((Node)new IntrinsicData());
                    s1_.asForeign_ = s1_.insertAccessor(LLVMAsForeignNode.create());
                    s1_.foreignWrite_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3));
                    s1_.readStr_ = s1_.insertAccessor(this.createReadString());
                    s1_.exception_ = BranchProfile.create();
                    this.intrinsic_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.doIntrinsic(child0Value_, child1Value, child2Value, s1_.asForeign_, s1_.foreignWrite_, s1_.readStr_, s1_.exception_);
                    Object var9_10 = null;
                    return var9_10;
                }
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.fallback(child0Value, child1Value, child2Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state_0, Object child0Value, Object child1Value, Object child2Value) {
            return (state_0 & 1) != 0 || !LLVMTypes.isManagedPointer(child0Value);
        }

        public static LLVMPolyglotWrite.LLVMPolyglotPutMember create(Type[] argTypes, LLVMExpressionNode child0, LLVMExpressionNode child1, LLVMExpressionNode child2) {
            return new LLVMPolyglotPutMemberNodeGen(argTypes, child0, child1, child2);
        }

        @GeneratedBy(value=LLVMPolyglotWrite.LLVMPolyglotPutMember.class)
        private static final class IntrinsicData
        extends Node {
            @Node.Child
            LLVMAsForeignNode asForeign_;
            @Node.Child
            InteropLibrary foreignWrite_;
            @Node.Child
            LLVMReadStringNode readStr_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            IntrinsicData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

