/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteOrder;

@NodeChildren(value={@NodeChild(value="charset", type=LLVMReadCharsetNode.class), @NodeChild(value="rawString", type=ReadBytesNode.class, executeWith={"charset"})})
public abstract class LLVMPolyglotFromString
extends LLVMIntrinsic {
    public static LLVMPolyglotFromString create(LLVMExpressionNode string, LLVMExpressionNode charset) {
        LLVMReadCharsetNode charsetNode = LLVMReadCharsetNodeGen.create(charset);
        ReadZeroTerminatedBytesNode rawString = LLVMPolyglotFromStringNodeGen.ReadZeroTerminatedBytesNodeGen.create(null, string);
        return LLVMPolyglotFromStringNodeGen.create(charsetNode, rawString);
    }

    public static LLVMPolyglotFromString createN(LLVMExpressionNode string, LLVMExpressionNode n, LLVMExpressionNode charset) {
        LLVMReadCharsetNode charsetNode = LLVMReadCharsetNodeGen.create(charset);
        ReadBytesWithLengthNode rawString = LLVMPolyglotFromStringNodeGen.ReadBytesWithLengthNodeGen.create(null, string, n);
        return LLVMPolyglotFromStringNodeGen.create(charsetNode, rawString);
    }

    @Specialization
    LLVMManagedPointer doFromString(LLVMReadCharsetNode.LLVMCharset charset, byte[] rawString) {
        return LLVMManagedPointer.create(charset.decode(rawString));
    }

    static abstract class PutCharNode
    extends LLVMNode {
        PutCharNode() {
        }

        protected abstract int execute(byte[] var1, Object var2, ByteArraySupport var3, int var4);

        @Specialization
        int doByte(byte[] target, byte value, ByteArraySupport byteArraySupport, int index) {
            if (value == 0) {
                return 0;
            }
            byteArraySupport.putByte(target, index, value);
            return 1;
        }

        @Specialization
        int doShort(byte[] target, short value, ByteArraySupport byteArraySupport, int index) {
            if (value == 0) {
                return 0;
            }
            byteArraySupport.putShort(target, index, value);
            return 2;
        }

        @Specialization
        int doInt(byte[] target, int value, ByteArraySupport byteArraySupport, int index) {
            if (value == 0) {
                return 0;
            }
            byteArraySupport.putInt(target, index, value);
            return 4;
        }

        @Specialization
        int doLong(byte[] target, long value, ByteArraySupport byteArraySupport, int index) {
            if (value == 0L) {
                return 0;
            }
            byteArraySupport.putLong(target, index, value);
            return 8;
        }

        public static PutCharNode create() {
            return LLVMPolyglotFromStringNodeGen.PutCharNodeGen.create();
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMReadCharsetNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    static abstract class ReadZeroTerminatedBytesNode
    extends ReadBytesNode {
        @CompilerDirectives.CompilationFinal
        int bufferSize = 8;

        ReadZeroTerminatedBytesNode() {
        }

        @Specialization(limit="4", guards={"charset.zeroTerminatorLen == increment"})
        byte[] doRead(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, @Cached(value="charset.zeroTerminatorLen") int increment, @Cached(value="createLoad(increment)") LLVMLoadNode load, @Cached(value="create()") PutCharNode put) {
            int i;
            int capacity = this.bufferSize;
            int size = 0;
            byte[] result = new byte[capacity];
            ByteArraySupport byteArraySupport = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteArraySupport.bigEndian() : ByteArraySupport.littleEndian();
            LLVMPointer ptr = string;
            while (true) {
                int written;
                Object value = load.executeWithTargetGeneric(ptr);
                ptr = ptr.increment(increment);
                if (capacity - size < increment) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    byte[] newResult = new byte[capacity *= 2];
                    for (i = 0; i < size; ++i) {
                        newResult[i] = result[i];
                    }
                    result = newResult;
                }
                if ((written = put.execute(result, value, byteArraySupport, size)) == 0) break;
                size += written;
            }
            if (capacity > size) {
                capacity = size;
                byte[] newResult = new byte[capacity];
                for (i = 0; i < size; ++i) {
                    newResult[i] = result[i];
                }
                result = newResult;
            }
            if (capacity > this.bufferSize) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bufferSize = capacity;
            }
            return result;
        }

        protected static LLVMLoadNode createLoad(int increment) {
            switch (increment) {
                case 1: {
                    return LLVMI8LoadNode.create();
                }
                case 2: {
                    return LLVMI16LoadNode.create();
                }
                case 4: {
                    return LLVMI32LoadNode.create();
                }
                case 8: {
                    return LLVMI64LoadNode.create();
                }
            }
            throw new AssertionError((Object)"should not reach here");
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMReadCharsetNode.class), @NodeChild(value="string", type=LLVMExpressionNode.class), @NodeChild(value="len", type=LLVMExpressionNode.class)})
    static abstract class ReadBytesWithLengthNode
    extends ReadBytesNode {
        @Node.Child
        private LLVMI8LoadNode.LLVMI8OffsetLoadNode load = LLVMI8LoadNode.LLVMI8OffsetLoadNode.create();

        ReadBytesWithLengthNode() {
        }

        @Specialization
        byte[] doRead(LLVMReadCharsetNode.LLVMCharset charset, LLVMPointer string, long len) {
            byte[] buffer = new byte[(int)len];
            int i = 0;
            while ((long)i < len) {
                buffer[i] = this.load.executeWithTarget(string, i * 1);
                ++i;
            }
            return buffer;
        }
    }

    static abstract class ReadBytesNode
    extends LLVMNode {
        ReadBytesNode() {
        }

        protected abstract byte[] execute(VirtualFrame var1, LLVMReadCharsetNode.LLVMCharset var2);
    }
}

