/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsPrimitiveFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotAsPrimitive
extends LLVMIntrinsic {
    @Fallback
    boolean onFallback(Object receiver) {
        throw new LLVMPolyglotException(this, "Pointer does not point to a polyglot value");
    }

    public static abstract class AsDouble
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsDoubleNodeGen.create(arg);
        }

        @Specialization(guards={"foreigns.isForeign(receiver)"}, limit="3")
        double asDouble(Object receiver, @CachedLibrary(value="receiver") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asDouble(foreigns.asForeign(receiver));
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_double cannot be converted to double.");
            }
        }
    }

    public static abstract class AsFloat
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsFloatNodeGen.create(arg);
        }

        @Specialization(guards={"foreigns.isForeign(receiver)"}, limit="3")
        float asFloat(Object receiver, @CachedLibrary(value="receiver") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asFloat(foreigns.asForeign(receiver));
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_float cannot be converted to float.");
            }
        }
    }

    public static abstract class AsI64
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsI64NodeGen.create(arg);
        }

        @Specialization(guards={"foreigns.isForeign(receiver)"}, limit="3")
        long asI64(Object receiver, @CachedLibrary(value="receiver") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asLong(foreigns.asForeign(receiver));
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_i64 cannot be converted to i64.");
            }
        }
    }

    public static abstract class AsI32
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsI32NodeGen.create(arg);
        }

        @Specialization(guards={"foreigns.isForeign(receiver)"}, limit="3")
        int asI32(Object receiver, @CachedLibrary(value="receiver") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asInt(foreigns.asForeign(receiver));
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_i32 cannot be converted to i32.");
            }
        }
    }

    public static abstract class AsI16
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsI16NodeGen.create(arg);
        }

        @Specialization(guards={"foreigns.isForeign(receiver)"}, limit="3")
        short asI16(Object receiver, @CachedLibrary(value="receiver") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asShort(foreigns.asForeign(receiver));
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_i16 cannot be converted to i16.");
            }
        }
    }

    public static abstract class AsI8
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsI8NodeGen.create(arg);
        }

        @Specialization(guards={"foreigns.isForeign(receiver)"}, limit="3")
        byte asI8(Object receiver, @CachedLibrary(value="receiver") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asByte(foreigns.asForeign(receiver));
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_i8 cannot be converted to i8.");
            }
        }
    }

    public static abstract class AsBoolean
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsBooleanNodeGen.create(arg);
        }

        @Specialization(guards={"foreigns.isForeign(receiver)"}, limit="3")
        boolean asBoolean(Object receiver, @CachedLibrary(value="receiver") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asBoolean(foreigns.asForeign(receiver));
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_boolean cannot be converted to boolean.");
            }
        }
    }
}

