/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSyscall;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMSyscall.class)
public final class LLVMSyscallFactory {

    @GeneratedBy(value=LLVMSyscall.SyscallArgConverter.class)
    static final class SyscallArgConverterNodeGen
    extends LLVMSyscall.SyscallArgConverter {
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private SyscallArgConverterNodeGen(LLVMExpressionNode value) {
            this.value_ = value;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3E) == 0 && state_0 != 0) {
                return this.executeGeneric_long0(state_0, frameValue);
            }
            if ((state_0 & 0x3D) == 0 && state_0 != 0) {
                return this.executeGeneric_int1(state_0, frameValue);
            }
            if ((state_0 & 0x3B) == 0 && state_0 != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x37) == 0 && state_0 != 0) {
                return this.executeGeneric_byte3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_long0(int state_0, VirtualFrame frameValue) {
            long valueValue_;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_int1(int state_0, VirtualFrame frameValue) {
            int valueValue_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_short2(int state_0, VirtualFrame frameValue) {
            short valueValue_;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_byte3(int state_0, VirtualFrame frameValue) {
            byte valueValue_;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_generic4(int state_0, VirtualFrame frameValue) {
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && valueValue_ instanceof Long) {
                long valueValue__ = (Long)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state_0 & 2) != 0 && valueValue_ instanceof Integer) {
                int valueValue__ = (Integer)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state_0 & 4) != 0 && valueValue_ instanceof Short) {
                short valueValue__ = (Short)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state_0 & 8) != 0 && valueValue_ instanceof Byte) {
                byte valueValue__ = (Byte)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state_0 & 0x10) != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state_0 & 0x20) != 0 && SyscallArgConverterNodeGen.fallbackGuard_(state_0, valueValue_)) {
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(valueValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0x20) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 0xE) == 0 && (state_0 & 0xF) != 0) {
                return this.executeI64_long5(state_0, frameValue);
            }
            if ((state_0 & 0xD) == 0 && (state_0 & 0xF) != 0) {
                return this.executeI64_int6(state_0, frameValue);
            }
            if ((state_0 & 0xB) == 0 && (state_0 & 0xF) != 0) {
                return this.executeI64_short7(state_0, frameValue);
            }
            if ((state_0 & 7) == 0 && (state_0 & 0xF) != 0) {
                return this.executeI64_byte8(state_0, frameValue);
            }
            return this.executeI64_generic9(state_0, frameValue);
        }

        private long executeI64_long5(int state_0, VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 1) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_int6(int state_0, VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 2) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_short7(int state_0, VirtualFrame frameValue) throws UnexpectedResultException {
            short valueValue_;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 4) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_byte8(int state_0, VirtualFrame frameValue) throws UnexpectedResultException {
            byte valueValue_;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 8) != 0);
            return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_generic9(int state_0, VirtualFrame frameValue) throws UnexpectedResultException {
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && valueValue_ instanceof Long) {
                long valueValue__ = (Long)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state_0 & 2) != 0 && valueValue_ instanceof Integer) {
                int valueValue__ = (Integer)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state_0 & 4) != 0 && valueValue_ instanceof Short) {
                short valueValue__ = (Short)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            if ((state_0 & 8) != 0 && valueValue_ instanceof Byte) {
                byte valueValue__ = (Byte)valueValue_;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(valueValue_));
        }

        private Object executeAndSpecialize(Object valueValue) {
            int state_0 = this.state_0_;
            if (valueValue instanceof Long) {
                long valueValue_ = (Long)valueValue;
                this.state_0_ = state_0 |= 1;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                this.state_0_ = state_0 |= 2;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Short) {
                short valueValue_ = (Short)valueValue;
                this.state_0_ = state_0 |= 4;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Byte) {
                byte valueValue_ = (Byte)valueValue;
                this.state_0_ = state_0 |= 8;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            if (LLVMTypes.isPointer(valueValue)) {
                LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                this.state_0_ = state_0 |= 0x10;
                return LLVMSyscall.SyscallArgConverter.convert(valueValue_);
            }
            this.state_0_ = state_0 |= 0x20;
            return LLVMSyscall.SyscallArgConverter.convert(valueValue);
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state_0, Object valueValue) {
            if ((state_0 & 1) == 0 && valueValue instanceof Long) {
                return false;
            }
            if ((state_0 & 2) == 0 && valueValue instanceof Integer) {
                return false;
            }
            if ((state_0 & 4) == 0 && valueValue instanceof Short) {
                return false;
            }
            if ((state_0 & 8) == 0 && valueValue instanceof Byte) {
                return false;
            }
            return (state_0 & 0x10) != 0 || !LLVMTypes.isPointer(valueValue);
        }

        public static LLVMSyscall.SyscallArgConverter create(LLVMExpressionNode value) {
            return new SyscallArgConverterNodeGen(value);
        }
    }
}

