/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public abstract class LLVMMemIntrinsic
extends LLVMExpressionNode {

    @NodeChildren(value={@NodeChild(value="dst", type=LLVMExpressionNode.class), @NodeChild(value="src", type=LLVMExpressionNode.class), @NodeChild(value="len", type=LLVMExpressionNode.class)})
    public static abstract class LLVMLibcMemcpy
    extends LLVMMemIntrinsic {
        @Node.Child
        private LLVMMemMoveNode memcpy;

        public LLVMLibcMemcpy(LLVMMemMoveNode memcpy) {
            this.memcpy = memcpy;
        }

        @Specialization
        protected Object op(Object dst, Object src, int len) {
            this.memcpy.executeWithTarget(dst, src, len);
            return dst;
        }

        @Specialization
        protected Object op(Object dst, Object src, long len) {
            this.memcpy.executeWithTarget(dst, src, len);
            return dst;
        }
    }

    @NodeChildren(value={@NodeChild(value="dst", type=LLVMExpressionNode.class), @NodeChild(value="value", type=LLVMExpressionNode.class), @NodeChild(value="len", type=LLVMExpressionNode.class)})
    public static abstract class LLVMLibcMemset
    extends LLVMMemIntrinsic {
        @Node.Child
        private LLVMMemSetNode memset;

        public LLVMLibcMemset(LLVMMemSetNode memset) {
            this.memset = memset;
        }

        @Specialization
        protected Object op(Object dst, int val, int len) {
            this.memset.executeWithTarget(dst, (byte)val, len);
            return dst;
        }

        @Specialization
        protected Object op(Object dst, int val, long len) {
            this.memset.executeWithTarget(dst, (byte)val, len);
            return dst;
        }

        @Specialization
        protected Object op(Object dst, byte val, int len) {
            this.memset.executeWithTarget(dst, val, len);
            return dst;
        }

        @Specialization
        protected Object op(Object dst, byte val, long len) {
            this.memset.executeWithTarget(dst, val, len);
            return dst;
        }
    }
}

