/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMResumeNodeWrapper;

@GenerateWrapper
@NodeField(name="exceptionSlot", type=FrameSlot.class)
public abstract class LLVMResumeNode
extends LLVMControlFlowNode {
    public abstract void execute(VirtualFrame var1);

    abstract FrameSlot getExceptionSlot();

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMResumeNodeWrapper(this, probe);
    }

    @Override
    public int getSuccessorCount() {
        return 0;
    }

    @Override
    public int[] getSuccessors() {
        return new int[0];
    }

    @Override
    public LLVMStatementNode getPhiNode(int successorIndex) {
        return null;
    }

    @Specialization
    void doRethrow(VirtualFrame frame) {
        try {
            LLVMUserException thrownException = (LLVMUserException)((Object)frame.getObject(this.getExceptionSlot()));
            throw thrownException;
        }
        catch (FrameSlotTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }
}

