/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(value="function", type=LLVMExpressionNode.class)
public abstract class LLVMLookupDispatchTargetNode
extends LLVMExpressionNode {
    protected static final int INLINE_CACHE_SIZE = 5;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> languageRef;

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"isSameObject(pointer.getObject(), cachedDescriptor)", "cachedDescriptor != null", "pointer.getOffset() == 0"}, assumptions={"singleContextAssumption()"})
    protected static LLVMFunctionDescriptor doDirectCached(LLVMManagedPointer pointer, @Cached(value="asFunctionDescriptor(pointer.getObject())") LLVMFunctionDescriptor cachedDescriptor) {
        return cachedDescriptor;
    }

    @Specialization(guards={"isFunctionDescriptor(pointer.getObject())", "pointer.getOffset() == 0"}, replaces={"doDirectCached"})
    protected static LLVMFunctionDescriptor doDirect(LLVMManagedPointer pointer) {
        return (LLVMFunctionDescriptor)pointer.getObject();
    }

    @Specialization(guards={"foreigns.isForeign(pointer.getObject())", "pointer.getOffset() == 0"})
    protected Object doForeign(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return pointer.getObject();
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"pointer.asNative() == cachedAddress", "!isAutoDerefHandle(cachedAddress)", "cachedDescriptor != null"}, assumptions={"singleContextAssumption()"})
    protected static LLVMFunctionDescriptor doHandleCached(LLVMNativePointer pointer, @Cached(value="pointer.asNative()") long cachedAddress, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef, @Cached(value="lookupFunction(ctxRef, pointer)") LLVMFunctionDescriptor cachedDescriptor) {
        return cachedDescriptor;
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"pointer.asNative() == cachedAddress", "!isAutoDerefHandle(cachedAddress)", "cachedDescriptor == null"}, assumptions={"singleContextAssumption()"})
    protected static LLVMNativePointer doNativeFunctionCached(LLVMNativePointer pointer, @Cached(value="pointer.asNative()") long cachedAddress, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef, @Cached(value="lookupFunction(ctxRef, pointer)") LLVMFunctionDescriptor cachedDescriptor) {
        return pointer;
    }

    @Specialization(guards={"!isAutoDerefHandle(pointer.asNative())", "cachedSymbol != null"}, replaces={"doHandleCached", "doNativeFunctionCached"}, rewriteOn={LLVMIllegalSymbolIndexException.class})
    protected Object doLookupNativeFunctionCachedSymbol(VirtualFrame frame, LLVMNativePointer pointer, @Cached(value="lookupFunctionSymbol(pointer)") LLVMAccessSymbolNode cachedSymbol) {
        LLVMFunctionDescriptor descriptor;
        long nativePointer;
        LLVMManagedPointer managedPointer;
        LLVMPointer symbolPointer;
        try {
            symbolPointer = cachedSymbol.executeGeneric(frame);
        }
        catch (NullPointerException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            symbolPointer = null;
        }
        if (LLVMManagedPointer.isInstance(symbolPointer) && (managedPointer = LLVMManagedPointer.cast(symbolPointer)).getOffset() == 0L && managedPointer.getObject() instanceof LLVMFunctionDescriptor && (nativePointer = (descriptor = (LLVMFunctionDescriptor)managedPointer.getObject()).getNativePointer()) != 0L && nativePointer == pointer.asNative()) {
            return descriptor;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new LLVMIllegalSymbolIndexException("mismatching function");
    }

    @Specialization(guards={"!isAutoDerefHandle(pointer.asNative())"}, replaces={"doLookupNativeFunctionCachedSymbol", "doHandleCached", "doNativeFunctionCached"})
    protected Object doLookup(LLVMNativePointer pointer, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
        LLVMFunctionDescriptor descriptor = this.lookupFunction(ctxRef, pointer);
        if (descriptor != null) {
            return descriptor;
        }
        return pointer;
    }

    @Specialization(guards={"isAutoDerefHandle(pointer.asNative())"})
    protected Object doDerefHandle(LLVMNativePointer pointer, @Cached LLVMDerefHandleGetReceiverNode getReceiver) {
        LLVMManagedPointer foreignFunction = getReceiver.execute(pointer);
        return foreignFunction.getObject();
    }

    protected LLVMFunctionDescriptor lookupFunction(TruffleLanguage.ContextReference<LLVMContext> ctxRef, LLVMNativePointer function) {
        return ((LLVMContext)ctxRef.get()).getFunctionDescriptor(function);
    }

    protected LLVMAccessSymbolNode lookupFunctionSymbol(LLVMNativePointer function) {
        CompilerAsserts.neverPartOfCompilation();
        LLVMContext context = LLVMLanguage.getContext();
        LLVMFunctionDescriptor descriptor = context.getFunctionDescriptor(function);
        return descriptor == null || descriptor.getLLVMFunction() == null ? null : LLVMAccessSymbolNodeGen.create(descriptor.getLLVMFunction());
    }

    protected boolean isAutoDerefHandle(long addr) {
        if (this.languageRef == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.languageRef = this.lookupLanguageReference(LLVMLanguage.class);
        }
        if (CompilerDirectives.inCompiledCode() && ((LLVMLanguage)this.languageRef.get()).getNoDerefHandleAssumption().isValid()) {
            return false;
        }
        return LLVMHandleMemoryBase.isDerefHandleMemory(addr);
    }

    public static LLVMExpressionNode createOptimized(LLVMExpressionNode function) {
        LLVMAccessSymbolNode node;
        if (function instanceof LLVMAccessSymbolNode && (node = (LLVMAccessSymbolNode)function).getSymbol() instanceof LLVMFunction) {
            return LLVMLookupDispatchTargetSymbolNodeGen.create((LLVMFunction)node.getSymbol());
        }
        return LLVMLookupDispatchTargetNodeGen.create(function);
    }
}

