/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import java.util.HashMap;
import java.util.Map;

public final class LLVMFunctionStartNode
extends LLVMRootNode
implements LLVMHasDatalayoutNode {
    @Node.Child
    private LLVMExpressionNode node;
    private final String name;
    private final int explicitArgumentsCount;
    private final String originalName;
    private final Source bcSource;
    private final LLVMSourceLocation sourceLocation;
    private final DataLayout dataLayout;

    public LLVMFunctionStartNode(LLVMLanguage language, LLVMStack.LLVMStackAccess stackAccess, LLVMExpressionNode node, FrameDescriptor frameDescriptor, String name, int explicitArgumentsCount, String originalName, Source bcSource, LLVMSourceLocation location, DataLayout dataLayout) {
        super(language, frameDescriptor, stackAccess);
        this.dataLayout = dataLayout;
        this.explicitArgumentsCount = explicitArgumentsCount;
        this.node = node;
        this.name = name;
        this.originalName = originalName;
        this.bcSource = bcSource;
        this.sourceLocation = location;
    }

    public String toString() {
        return this.name;
    }

    public SourceSection getSourceSection() {
        return this.sourceLocation.getSourceSection();
    }

    public boolean isInternal() {
        return this.bcSource.isInternal();
    }

    public Object execute(VirtualFrame frame) {
        return this.node.executeGeneric(frame);
    }

    public String getName() {
        if (this.originalName != null) {
            return this.originalName;
        }
        return this.name;
    }

    public int getExplicitArgumentsCount() {
        return this.explicitArgumentsCount;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getBcName() {
        return this.name;
    }

    public Source getBcSource() {
        return this.bcSource;
    }

    @Override
    public DataLayout getDatalayout() {
        return this.dataLayout;
    }

    public Map<String, Object> getDebugProperties() {
        CompilerAsserts.neverPartOfCompilation();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.originalName != null) {
            properties.put("originalName", this.originalName);
        }
        if (this.bcSource != null) {
            properties.put("bcSource", this.bcSource);
        }
        if (this.sourceLocation != null) {
            properties.put("sourceLocation", this.sourceLocation);
        }
        return properties;
    }
}

