/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMLoopNode;

@GeneratedBy(value=LLVMLoopNode.class)
final class LLVMLoopNodeWrapper
extends LLVMLoopNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private LLVMLoopNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    LLVMLoopNodeWrapper(LLVMLoopNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public LLVMLoopNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public void executeLoop(VirtualFrame frame) {
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                this.delegateNode.executeLoop(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, null);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) break;
                throw t;
            }
            break;
        }
    }

    @Override
    public int getSuccessorCount() {
        return this.delegateNode.getSuccessorCount();
    }

    @Override
    public int[] getSuccessors() {
        return this.delegateNode.getSuccessors();
    }

    @Override
    public LLVMStatementNode getPhiNode(int successorIndex) {
        return this.delegateNode.getPhiNode(successorIndex);
    }
}

