/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.base;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;

public final class LLVMFrameNullerUtil {
    private LLVMFrameNullerUtil() {
    }

    public static void nullFrameSlot(VirtualFrame frame, FrameSlot frameSlot) {
        CompilerAsserts.partialEvaluationConstant((Object)frameSlot);
        if (CompilerDirectives.inInterpreter()) {
            return;
        }
        FrameSlotKind kind = frame.getFrameDescriptor().getFrameSlotKind(frameSlot);
        if (kind == FrameSlotKind.Object) {
            frame.setObject(frameSlot, null);
        } else if (kind == FrameSlotKind.Boolean) {
            frame.setBoolean(frameSlot, false);
        } else if (kind == FrameSlotKind.Byte) {
            frame.setByte(frameSlot, (byte)0);
        } else if (kind == FrameSlotKind.Int) {
            frame.setInt(frameSlot, 0);
        } else if (kind == FrameSlotKind.Long) {
            frame.setLong(frameSlot, 0L);
        } else if (kind == FrameSlotKind.Float) {
            frame.setFloat(frameSlot, 0.0f);
        } else if (kind == FrameSlotKind.Double) {
            frame.setDouble(frameSlot, 0.0);
        } else {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("unexpected frameslot kind");
        }
    }
}

