/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMSyscallEntry;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.posix.LLVMPosixCallNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.posix.LLVMPosixCallNodeGen;

public class LLVMNativeSyscallNode
extends LLVMSyscallOperationNode {
    private final long nr;
    private final LLVMSyscallEntry syscallValue;
    @Node.Child
    private LLVMPosixCallNode syscall;

    public LLVMNativeSyscallNode(long nr) {
        this(nr, null);
    }

    public LLVMNativeSyscallNode(LLVMSyscallEntry syscall) {
        this(syscall.value(), syscall);
    }

    private LLVMNativeSyscallNode(long nr, LLVMSyscallEntry syscallValue) {
        this.nr = nr;
        this.syscallValue = syscallValue;
        this.syscall = LLVMPosixCallNodeGen.create("syscall", "(SINT64, POINTER, POINTER, POINTER, POINTER, POINTER, POINTER):SINT64");
    }

    @Override
    public final String getName() {
        if (this.syscallValue != null) {
            return this.syscallValue.toString();
        }
        return "native_syscall(" + this.nr + ")";
    }

    @Override
    public long execute(Object rdi, Object rsi, Object rdx, Object r10, Object r8, Object r9) {
        return (Long)this.syscall.execute(this.nr, rdi, rsi, rdx, r10, r8, r9);
    }
}

