/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public abstract class LLVMAMD64ToRegisterNode
extends LLVMExpressionNode {

    @NodeChild(value="from", type=LLVMExpressionNode.class)
    public static abstract class LLVMI32ToR64
    extends LLVMAMD64ToRegisterNode {
        private static final long MASK = 0xFFFFFFFFL;

        @Specialization
        protected long doI64(byte from) {
            return Byte.toUnsignedLong(from);
        }

        @Specialization
        protected long doI64(short from) {
            return Short.toUnsignedLong(from);
        }

        @Specialization
        protected long doI64(int from) {
            return Integer.toUnsignedLong(from);
        }

        @Specialization
        protected long doI64(long from) {
            return from & 0xFFFFFFFFL;
        }
    }

    @NodeChildren(value={@NodeChild(value="reg", type=LLVMExpressionNode.class), @NodeChild(value="from", type=LLVMExpressionNode.class)})
    public static abstract class LLVMI16ToR64
    extends LLVMAMD64ToRegisterNode {
        private final long mask = -65536L;

        @Specialization
        protected long doI64(long reg, byte from) {
            return reg & 0xFFFFFFFFFFFF0000L | Byte.toUnsignedLong(from);
        }

        @Specialization
        protected long doI64(long reg, short from) {
            return reg & 0xFFFFFFFFFFFF0000L | Short.toUnsignedLong(from);
        }

        @Specialization
        protected long doI64(long reg, int from) {
            return reg & 0xFFFFFFFFFFFF0000L | (long)from & 0xFFFFL;
        }

        @Specialization
        protected long doI64(long reg, long from) {
            return reg & 0xFFFFFFFFFFFF0000L | from & 0xFFFFL;
        }
    }

    @NodeChildren(value={@NodeChild(value="reg", type=LLVMExpressionNode.class), @NodeChild(value="from", type=LLVMExpressionNode.class)})
    public static abstract class LLVMI8ToR64
    extends LLVMAMD64ToRegisterNode {
        private final int shift;
        private final long mask;

        public LLVMI8ToR64(int shift) {
            this.shift = shift;
            this.mask = 255L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Specialization
        protected long doI64(long reg, byte from) {
            return reg & this.mask | Byte.toUnsignedLong(from) << this.shift;
        }

        @Specialization
        protected long doI64(long reg, short from) {
            return reg & this.mask | ((long)from & (this.mask ^ 0xFFFFFFFFFFFFFFFFL)) << this.shift;
        }

        @Specialization
        protected long doI64(long reg, int from) {
            return reg & this.mask | ((long)from & (this.mask ^ 0xFFFFFFFFFFFFFFFFL)) << this.shift;
        }

        @Specialization
        protected long doI64(long reg, long from) {
            return reg & this.mask | (from & (this.mask ^ 0xFFFFFFFFFFFFFFFFL)) << this.shift;
        }
    }
}

