/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StosNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMAMD64StosNode.class)
public final class LLVMAMD64StosNodeFactory {

    @GeneratedBy(value=LLVMAMD64StosNode.LLVMAMD64StosqNode.class)
    public static final class LLVMAMD64StosqNodeGen
    extends LLVMAMD64StosNode.LLVMAMD64StosqNode {
        @Node.Child
        private LLVMExpressionNode rax_;
        @Node.Child
        private LLVMExpressionNode rdi_;
        @Node.Child
        private LLVMExpressionNode df_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64StosqNodeGen(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            super(writeRDI);
            this.rax_ = rax;
            this.rdi_ = rdi;
            this.df_ = df;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            long raxValue_;
            int state_0 = this.state_0_;
            try {
                raxValue_ = this.rax_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rdiValue = this.rdi_.executeGeneric(frameValue);
                Object dfValue = this.df_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rdiValue, dfValue);
                return;
            }
            if ((state_0 & 2) == 0 && state_0 != 0) {
                this.execute_long_boolean0(state_0, frameValue, raxValue_);
                return;
            }
            if ((state_0 & 1) == 0 && state_0 != 0) {
                this.execute_boolean1(state_0, frameValue, raxValue_);
                return;
            }
            this.execute_generic2(state_0, frameValue, raxValue_);
        }

        private void execute_long_boolean0(int state_0, VirtualFrame frameValue, long raxValue_) {
            boolean dfValue_;
            long rdiValue_;
            try {
                rdiValue_ = this.rdi_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dfValue = this.df_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, raxValue_, ex.getResult(), dfValue);
                return;
            }
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            assert ((state_0 & 1) != 0);
            this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void execute_boolean1(int state_0, VirtualFrame frameValue, long raxValue_) {
            boolean dfValue_;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void execute_generic2(int state_0, VirtualFrame frameValue, long raxValue_) {
            boolean dfValue_;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if ((state_0 & 1) != 0 && rdiValue_ instanceof Long) {
                long rdiValue__ = (Long)rdiValue_;
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object raxValue, Object rdiValue, Object dfValue) {
            int state_0 = this.state_0_;
            if (raxValue instanceof Long) {
                long raxValue_ = (Long)raxValue;
                if (dfValue instanceof Boolean) {
                    boolean dfValue_ = (Boolean)dfValue;
                    if (rdiValue instanceof Long) {
                        long rdiValue_ = (Long)rdiValue;
                        this.state_0_ = state_0 |= 1;
                        this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                    if (LLVMTypes.isPointer(rdiValue)) {
                        LLVMPointer rdiValue_ = LLVMTypes.asPointer(rdiValue);
                        this.state_0_ = state_0 |= 2;
                        this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.rax_, this.rdi_, this.df_}, new Object[]{raxValue, rdiValue, dfValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64StosNode.LLVMAMD64StosqNode create(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            return new LLVMAMD64StosqNodeGen(writeRDI, rax, rdi, df);
        }
    }

    @GeneratedBy(value=LLVMAMD64StosNode.LLVMAMD64StosdNode.class)
    public static final class LLVMAMD64StosdNodeGen
    extends LLVMAMD64StosNode.LLVMAMD64StosdNode {
        @Node.Child
        private LLVMExpressionNode rax_;
        @Node.Child
        private LLVMExpressionNode rdi_;
        @Node.Child
        private LLVMExpressionNode df_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64StosdNodeGen(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            super(writeRDI);
            this.rax_ = rax;
            this.rdi_ = rdi;
            this.df_ = df;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int raxValue_;
            int state_0 = this.state_0_;
            try {
                raxValue_ = this.rax_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rdiValue = this.rdi_.executeGeneric(frameValue);
                Object dfValue = this.df_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rdiValue, dfValue);
                return;
            }
            if ((state_0 & 2) == 0 && state_0 != 0) {
                this.execute_long_boolean0(state_0, frameValue, raxValue_);
                return;
            }
            if ((state_0 & 1) == 0 && state_0 != 0) {
                this.execute_boolean1(state_0, frameValue, raxValue_);
                return;
            }
            this.execute_generic2(state_0, frameValue, raxValue_);
        }

        private void execute_long_boolean0(int state_0, VirtualFrame frameValue, int raxValue_) {
            boolean dfValue_;
            long rdiValue_;
            try {
                rdiValue_ = this.rdi_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dfValue = this.df_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, raxValue_, ex.getResult(), dfValue);
                return;
            }
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            assert ((state_0 & 1) != 0);
            this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void execute_boolean1(int state_0, VirtualFrame frameValue, int raxValue_) {
            boolean dfValue_;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void execute_generic2(int state_0, VirtualFrame frameValue, int raxValue_) {
            boolean dfValue_;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if ((state_0 & 1) != 0 && rdiValue_ instanceof Long) {
                long rdiValue__ = (Long)rdiValue_;
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object raxValue, Object rdiValue, Object dfValue) {
            int state_0 = this.state_0_;
            if (raxValue instanceof Integer) {
                int raxValue_ = (Integer)raxValue;
                if (dfValue instanceof Boolean) {
                    boolean dfValue_ = (Boolean)dfValue;
                    if (rdiValue instanceof Long) {
                        long rdiValue_ = (Long)rdiValue;
                        this.state_0_ = state_0 |= 1;
                        this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                    if (LLVMTypes.isPointer(rdiValue)) {
                        LLVMPointer rdiValue_ = LLVMTypes.asPointer(rdiValue);
                        this.state_0_ = state_0 |= 2;
                        this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.rax_, this.rdi_, this.df_}, new Object[]{raxValue, rdiValue, dfValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64StosNode.LLVMAMD64StosdNode create(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            return new LLVMAMD64StosdNodeGen(writeRDI, rax, rdi, df);
        }
    }

    @GeneratedBy(value=LLVMAMD64StosNode.LLVMAMD64StoswNode.class)
    public static final class LLVMAMD64StoswNodeGen
    extends LLVMAMD64StosNode.LLVMAMD64StoswNode {
        @Node.Child
        private LLVMExpressionNode rax_;
        @Node.Child
        private LLVMExpressionNode rdi_;
        @Node.Child
        private LLVMExpressionNode df_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64StoswNodeGen(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            super(writeRDI);
            this.rax_ = rax;
            this.rdi_ = rdi;
            this.df_ = df;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short raxValue_;
            int state_0 = this.state_0_;
            try {
                raxValue_ = this.rax_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rdiValue = this.rdi_.executeGeneric(frameValue);
                Object dfValue = this.df_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rdiValue, dfValue);
                return;
            }
            if ((state_0 & 2) == 0 && state_0 != 0) {
                this.execute_long_boolean0(state_0, frameValue, raxValue_);
                return;
            }
            if ((state_0 & 1) == 0 && state_0 != 0) {
                this.execute_boolean1(state_0, frameValue, raxValue_);
                return;
            }
            this.execute_generic2(state_0, frameValue, raxValue_);
        }

        private void execute_long_boolean0(int state_0, VirtualFrame frameValue, short raxValue_) {
            boolean dfValue_;
            long rdiValue_;
            try {
                rdiValue_ = this.rdi_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dfValue = this.df_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, raxValue_, ex.getResult(), dfValue);
                return;
            }
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            assert ((state_0 & 1) != 0);
            this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void execute_boolean1(int state_0, VirtualFrame frameValue, short raxValue_) {
            boolean dfValue_;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void execute_generic2(int state_0, VirtualFrame frameValue, short raxValue_) {
            boolean dfValue_;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if ((state_0 & 1) != 0 && rdiValue_ instanceof Long) {
                long rdiValue__ = (Long)rdiValue_;
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object raxValue, Object rdiValue, Object dfValue) {
            int state_0 = this.state_0_;
            if (raxValue instanceof Short) {
                short raxValue_ = (Short)raxValue;
                if (dfValue instanceof Boolean) {
                    boolean dfValue_ = (Boolean)dfValue;
                    if (rdiValue instanceof Long) {
                        long rdiValue_ = (Long)rdiValue;
                        this.state_0_ = state_0 |= 1;
                        this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                    if (LLVMTypes.isPointer(rdiValue)) {
                        LLVMPointer rdiValue_ = LLVMTypes.asPointer(rdiValue);
                        this.state_0_ = state_0 |= 2;
                        this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.rax_, this.rdi_, this.df_}, new Object[]{raxValue, rdiValue, dfValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64StosNode.LLVMAMD64StoswNode create(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            return new LLVMAMD64StoswNodeGen(writeRDI, rax, rdi, df);
        }
    }

    @GeneratedBy(value=LLVMAMD64StosNode.LLVMAMD64StosbNode.class)
    public static final class LLVMAMD64StosbNodeGen
    extends LLVMAMD64StosNode.LLVMAMD64StosbNode {
        @Node.Child
        private LLVMExpressionNode rax_;
        @Node.Child
        private LLVMExpressionNode rdi_;
        @Node.Child
        private LLVMExpressionNode df_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64StosbNodeGen(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            super(writeRDI);
            this.rax_ = rax;
            this.rdi_ = rdi;
            this.df_ = df;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            byte raxValue_;
            int state_0 = this.state_0_;
            try {
                raxValue_ = this.rax_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rdiValue = this.rdi_.executeGeneric(frameValue);
                Object dfValue = this.df_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rdiValue, dfValue);
                return;
            }
            if ((state_0 & 2) == 0 && state_0 != 0) {
                this.execute_long_boolean0(state_0, frameValue, raxValue_);
                return;
            }
            if ((state_0 & 1) == 0 && state_0 != 0) {
                this.execute_boolean1(state_0, frameValue, raxValue_);
                return;
            }
            this.execute_generic2(state_0, frameValue, raxValue_);
        }

        private void execute_long_boolean0(int state_0, VirtualFrame frameValue, byte raxValue_) {
            boolean dfValue_;
            long rdiValue_;
            try {
                rdiValue_ = this.rdi_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dfValue = this.df_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, raxValue_, ex.getResult(), dfValue);
                return;
            }
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            assert ((state_0 & 1) != 0);
            this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void execute_boolean1(int state_0, VirtualFrame frameValue, byte raxValue_) {
            boolean dfValue_;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            assert ((state_0 & 2) != 0);
            if (LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void execute_generic2(int state_0, VirtualFrame frameValue, byte raxValue_) {
            boolean dfValue_;
            Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
            try {
                dfValue_ = this.df_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, ex.getResult());
                return;
            }
            if ((state_0 & 1) != 0 && rdiValue_ instanceof Long) {
                long rdiValue__ = (Long)rdiValue_;
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(rdiValue_)) {
                LLVMPointer rdiValue__ = LLVMTypes.asPointer(rdiValue_);
                this.opI8(frameValue, raxValue_, rdiValue__, dfValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, raxValue_, rdiValue_, dfValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object raxValue, Object rdiValue, Object dfValue) {
            int state_0 = this.state_0_;
            if (raxValue instanceof Byte) {
                byte raxValue_ = (Byte)raxValue;
                if (dfValue instanceof Boolean) {
                    boolean dfValue_ = (Boolean)dfValue;
                    if (rdiValue instanceof Long) {
                        long rdiValue_ = (Long)rdiValue;
                        this.state_0_ = state_0 |= 1;
                        this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                    if (LLVMTypes.isPointer(rdiValue)) {
                        LLVMPointer rdiValue_ = LLVMTypes.asPointer(rdiValue);
                        this.state_0_ = state_0 |= 2;
                        this.opI8(frameValue, raxValue_, rdiValue_, dfValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.rax_, this.rdi_, this.df_}, new Object[]{raxValue, rdiValue, dfValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64StosNode.LLVMAMD64StosbNode create(LLVMAMD64WriteValueNode writeRDI, LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode df) {
            return new LLVMAMD64StosbNodeGen(writeRDI, rax, rdi, df);
        }
    }
}

