/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;

public abstract class LLVMAMD64RepNode
extends LLVMStatementNode {
    @Node.Child
    private LoopNode loop;

    public LLVMAMD64RepNode(LLVMAMD64WriteValueNode writeRCX, LLVMExpressionNode rcx, LLVMStatementNode body) {
        this.loop = Truffle.getRuntime().createLoopNode((RepeatingNode)new LLVMAMD64RepLoopNode(writeRCX, rcx, body));
    }

    @Specialization
    public void doRep(VirtualFrame frame) {
        this.loop.execute(frame);
    }

    private static class LLVMAMD64RepLoopNode
    extends LLVMNode
    implements RepeatingNode {
        @Node.Child
        private LLVMAMD64WriteValueNode writeRCX;
        @Node.Child
        private LLVMExpressionNode rcx;
        @Node.Child
        private LLVMStatementNode body;

        LLVMAMD64RepLoopNode(LLVMAMD64WriteValueNode writeRCX, LLVMExpressionNode rcx, LLVMStatementNode body) {
            this.writeRCX = writeRCX;
            this.rcx = rcx;
            this.body = body;
        }

        public boolean executeRepeating(VirtualFrame frame) {
            try {
                long rcxValue = this.rcx.executeI64(frame);
                if (rcxValue == 0L) {
                    return false;
                }
                this.body.execute(frame);
                this.writeRCX.execute(frame, rcxValue - 1L);
                return true;
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RuntimeException(e);
            }
        }
    }
}

