/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAMD64PopNode
extends LLVMExpressionNode {
    protected final LLVMStack.LLVMStackAccess stackAccess;

    protected LLVMAMD64PopNode(LLVMStack.LLVMStackAccess stackAccess) {
        this.stackAccess = stackAccess;
    }

    public static abstract class LLVMAMD64PopqNode
    extends LLVMAMD64PopNode {
        protected LLVMAMD64PopqNode(LLVMStack.LLVMStackAccess stackAccess) {
            super(stackAccess);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doI64(VirtualFrame frame, @Cached LLVMI64LoadNode load) {
            LLVMPointer stackPointer = this.stackAccess.executeGet(frame);
            try {
                Object object = load.executeWithTargetGeneric(stackPointer);
                return object;
            }
            finally {
                this.stackAccess.executeSet(frame, stackPointer.increment(8L));
            }
        }
    }

    public static abstract class LLVMAMD64PoplNode
    extends LLVMAMD64PopNode {
        protected LLVMAMD64PoplNode(LLVMStack.LLVMStackAccess stackAccess) {
            super(stackAccess);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doI32(VirtualFrame frame, @Cached LLVMI32LoadNode load) {
            LLVMPointer stackPointer = this.stackAccess.executeGet(frame);
            try {
                Integer n = load.executeWithTarget(stackPointer);
                return n;
            }
            finally {
                this.stackAccess.executeSet(frame, stackPointer.increment(4L));
            }
        }
    }

    public static abstract class LLVMAMD64PopwNode
    extends LLVMAMD64PopNode {
        protected LLVMAMD64PopwNode(LLVMStack.LLVMStackAccess stackAccess) {
            super(stackAccess);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doI16(VirtualFrame frame, @Cached LLVMI16LoadNode load) {
            LLVMPointer stackPointer = this.stackAccess.executeGet(frame);
            try {
                Short s = load.executeWithTarget(stackPointer);
                return s;
            }
            finally {
                this.stackAccess.executeSet(frame, stackPointer.increment(2L));
            }
        }
    }
}

