/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;

@NodeChild(value="level", type=LLVMExpressionNode.class)
public abstract class LLVMAMD64CpuidNode
extends LLVMStatementNode {
    public static final String BRAND = "Sulong";
    public static final String VENDOR_ID = "SulongLLVM64";
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final int[] BRAND_I32 = LLVMAMD64CpuidNode.getI32("Sulong", 12);
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final int[] VENDOR_ID_I32 = LLVMAMD64CpuidNode.getI32("SulongLLVM64", 3);
    private IntValueProfile profile;
    @Node.Child
    private LLVMAMD64WriteValueNode eax;
    @Node.Child
    private LLVMAMD64WriteValueNode ebx;
    @Node.Child
    private LLVMAMD64WriteValueNode ecx;
    @Node.Child
    private LLVMAMD64WriteValueNode edx;
    public static final int TSC_IS_SUPPORTED = 16;
    public static final int RDRND_IS_SUPPORTED = 0x40000000;
    public static final int RDSEED_IS_SUPPORTED = 262144;
    public static final int LM_IS_SUPPORTED = 0x20000000;
    public static final int LAHF_LM_IS_SUPPORTED = 1;

    private static int[] getI32(String s, int len) {
        CompilerAsserts.neverPartOfCompilation();
        int[] i32 = new int[len];
        for (int i = 0; i < len; ++i) {
            byte b1 = LLVMAMD64CpuidNode.getI8(s, i * 4);
            byte b2 = LLVMAMD64CpuidNode.getI8(s, i * 4 + 1);
            byte b3 = LLVMAMD64CpuidNode.getI8(s, i * 4 + 2);
            byte b4 = LLVMAMD64CpuidNode.getI8(s, i * 4 + 3);
            i32[i] = Byte.toUnsignedInt(b1) | Byte.toUnsignedInt(b2) << 8 | Byte.toUnsignedInt(b3) << 16 | Byte.toUnsignedInt(b4) << 24;
        }
        return i32;
    }

    private static byte getI8(String s, int offset) {
        CompilerAsserts.neverPartOfCompilation();
        if (offset >= s.length()) {
            return 0;
        }
        return (byte)s.charAt(offset);
    }

    public LLVMAMD64CpuidNode(LLVMAMD64WriteValueNode eax, LLVMAMD64WriteValueNode ebx, LLVMAMD64WriteValueNode ecx, LLVMAMD64WriteValueNode edx) {
        this.eax = eax;
        this.ebx = ebx;
        this.ecx = ecx;
        this.edx = edx;
        this.profile = IntValueProfile.createIdentityProfile();
    }

    @Specialization
    protected void doOp(VirtualFrame frame, int level) {
        int c;
        int d;
        int b;
        int a;
        switch (this.profile.profile(level)) {
            case 0: {
                a = 7;
                b = VENDOR_ID_I32[0];
                d = VENDOR_ID_I32[1];
                c = VENDOR_ID_I32[2];
                break;
            }
            case 1: {
                a = 0;
                b = 0;
                c = 0x40000000;
                d = 16;
                break;
            }
            case 7: {
                a = 0;
                b = 262144;
                c = 0;
                d = 0;
                break;
            }
            case -2147483648: {
                a = -2147483644;
                b = 0;
                c = 0;
                d = 0;
                break;
            }
            case -2147483647: {
                a = 0;
                b = 0;
                c = 1;
                d = 0x20000000;
                break;
            }
            case -2147483646: {
                a = BRAND_I32[0];
                b = BRAND_I32[1];
                c = BRAND_I32[2];
                d = BRAND_I32[3];
                break;
            }
            case -2147483645: {
                a = BRAND_I32[4];
                b = BRAND_I32[5];
                c = BRAND_I32[6];
                d = BRAND_I32[7];
                break;
            }
            case -2147483644: {
                a = BRAND_I32[8];
                b = BRAND_I32[9];
                c = BRAND_I32[10];
                d = BRAND_I32[11];
                break;
            }
            default: {
                a = 0;
                b = 0;
                c = 0;
                d = 0;
            }
        }
        this.eax.execute(frame, a);
        this.ebx.execute(frame, b);
        this.ecx.execute(frame, c);
        this.edx.execute(frame, d);
    }
}

