/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateLibrary
@GenerateLibrary.DefaultExport.Repeat(value={@GenerateLibrary.DefaultExport(value=LLVMManagedAccessDefaults.VirtualAlloc.class), @GenerateLibrary.DefaultExport(value=LLVMManagedAccessDefaults.FallbackRead.class)})
public abstract class LLVMManagedReadLibrary
extends Library {
    private static final LibraryFactory<LLVMManagedReadLibrary> FACTORY = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @GenerateLibrary.Abstract
    public boolean isReadable(Object receiver) {
        return false;
    }

    public abstract byte readI8(Object var1, long var2);

    public abstract short readI16(Object var1, long var2);

    public abstract int readI32(Object var1, long var2);

    public float readFloat(Object receiver, long offset) {
        return Float.intBitsToFloat(this.readI32(receiver, offset));
    }

    public long readI64(Object receiver, long offset) throws UnexpectedResultException {
        return LLVMTypesGen.expectLong(this.readGenericI64(receiver, offset));
    }

    public double readDouble(Object receiver, long offset) {
        try {
            return Double.longBitsToDouble(this.readI64(receiver, offset));
        }
        catch (UnexpectedResultException e) {
            return (Double)e.getResult();
        }
    }

    public abstract LLVMPointer readPointer(Object var1, long var2);

    public abstract Object readGenericI64(Object var1, long var2);

    public static LibraryFactory<LLVMManagedReadLibrary> getFactory() {
        return FACTORY;
    }
}

