/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaultsFactory;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.memory.UnsafeArrayAccess;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

abstract class LLVMManagedAccessDefaults {
    LLVMManagedAccessDefaults() {
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMManagedReadLibrary.class, receiverType=int[].class), @ExportLibrary(value=LLVMManagedWriteLibrary.class, receiverType=int[].class)})
    static class VirtualAlloc {
        VirtualAlloc() {
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
        static boolean isAccessible(int[] obj) {
            return true;
        }

        @ExportMessage
        static byte readI8(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getI8(obj, offset);
        }

        @ExportMessage
        static short readI16(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getI16(obj, offset);
        }

        @ExportMessage
        static int readI32(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getI32(obj, offset);
        }

        @ExportMessage(name="readGenericI64")
        static long readI64(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getI64(obj, offset);
        }

        @ExportMessage
        static float readFloat(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getFloat(obj, offset);
        }

        @ExportMessage
        static double readDouble(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getDouble(obj, offset);
        }

        @ExportMessage
        static LLVMPointer readPointer(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return LLVMNativePointer.create(VirtualAlloc.readI64(obj, offset, language));
        }

        @ExportMessage
        static void writeI8(int[] obj, long offset, byte value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeI8(obj, offset, value);
        }

        @ExportMessage
        static void writeI16(int[] obj, long offset, short value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeI16(obj, offset, value);
        }

        @ExportMessage
        static void writeI32(int[] obj, long offset, int value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeI32(obj, offset, value);
        }

        @ExportMessage
        static void writeI64(int[] obj, long offset, long value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeI64(obj, offset, value);
        }

        @ExportMessage
        static void writeFloat(int[] obj, long offset, float value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeFloat(obj, offset, value);
        }

        @ExportMessage
        static void writeDouble(int[] obj, long offset, double value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeDouble(obj, offset, value);
        }

        @ExportMessage
        static class WriteGenericI64 {
            WriteGenericI64() {
            }

            @Specialization
            static void writeI64(int[] obj, long offset, long value, @CachedLanguage LLVMLanguage language) {
                language.getCapability(UnsafeArrayAccess.class).writeI64(obj, offset, value);
            }

            @Specialization(limit="3")
            static void writePointer(int[] obj, long offset, LLVMPointer value, @CachedLibrary(value="value") LLVMNativeLibrary nativeLib, @CachedLanguage LLVMLanguage language) {
                WriteGenericI64.writeI64(obj, offset, nativeLib.toNativePointer(value).asNative(), language);
            }
        }
    }

    @GenerateUncached
    static abstract class GetWriteIdentifierNode
    extends LLVMNode {
        GetWriteIdentifierNode() {
        }

        abstract long execute(long var1, Object var3);

        @Specialization
        long doByte(long offset, byte value) {
            return offset;
        }

        @Specialization
        long doShort(long offset, short value) {
            return offset / 2L;
        }

        @Specialization
        long doChar(long offset, char value) {
            return offset / 2L;
        }

        @Specialization
        long doInt(long offset, int value) {
            return offset / 4L;
        }

        @Specialization
        long doFloat(long offset, float value) {
            return offset / 4L;
        }

        @Fallback
        long doDouble(long offset, Object value) {
            return offset / 8L;
        }
    }

    @GenerateUncached
    static abstract class FallbackWriteNode
    extends LLVMNode {
        FallbackWriteNode() {
        }

        abstract void executeWrite(Object var1, long var2, Object var4, ForeignToLLVM.ForeignToLLVMType var5);

        @Specialization(limit="3", guards={"type == cachedType"})
        void doCachedType(Object obj, long offset, Object value, ForeignToLLVM.ForeignToLLVMType type, @Cached(value="type") ForeignToLLVM.ForeignToLLVMType cachedType, @Cached(parameters={"cachedType"}) LLVMDataEscapeNode dataEscape, @CachedLibrary(limit="5") InteropLibrary interop, @Cached GetWriteIdentifierNode getWriteIdentifier) {
            this.doWrite(obj, offset, value, dataEscape, interop, getWriteIdentifier);
        }

        @Specialization(replaces={"doCachedType"})
        @CompilerDirectives.TruffleBoundary
        void doUncached(Object obj, long offset, Object value, ForeignToLLVM.ForeignToLLVMType type) {
            this.doWrite(obj, offset, value, LLVMDataEscapeNode.getUncached(type), (InteropLibrary)InteropLibrary.getFactory().getUncached(), LLVMManagedAccessDefaultsFactory.GetWriteIdentifierNodeGen.getUncached());
        }

        private void doWrite(Object obj, long offset, Object value, LLVMDataEscapeNode dataEscape, InteropLibrary interop, GetWriteIdentifierNode getWriteIdentifier) {
            long identifier = getWriteIdentifier.execute(offset, value);
            Object escaped = dataEscape.executeWithTarget(value);
            try {
                interop.writeArrayElement(obj, identifier, escaped);
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }
    }

    @GenerateUncached
    static abstract class LLVMMemoryWriteNode
    extends LLVMNode {
        LLVMMemoryWriteNode() {
        }

        abstract void executeWrite(long var1, Object var3);

        @Specialization
        void writeI8(long ptr, byte value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI8((Node)this, ptr, value);
        }

        @Specialization
        void writeI16(long ptr, short value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI16((Node)this, ptr, value);
        }

        @Specialization
        void writeI32(long ptr, int value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI32((Node)this, ptr, value);
        }

        @Specialization
        void writeI64(long ptr, long value, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMNativeLibrary nativeLibrary) {
            long valuePointer = nativeLibrary.toNativePointer(value).asNative();
            language.getLLVMMemory().putI64((Node)this, ptr, valuePointer);
        }

        @Specialization
        void writeFloat(long ptr, float value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putFloat((Node)this, ptr, value);
        }

        @Specialization
        void writeDouble(long ptr, double value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putDouble((Node)this, ptr, value);
        }

        @Specialization
        void writePointer(long ptr, Object value, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMNativeLibrary nativeLibrary) {
            LLVMNativePointer nativePointer = nativeLibrary.toNativePointer(value);
            language.getLLVMMemory().putPointer((Node)this, ptr, nativePointer);
        }
    }

    @GenerateUncached
    static abstract class ManagedWriteNode
    extends ManagedAccessNode {
        ManagedWriteNode() {
        }

        public boolean canAccess(Object obj, InteropLibrary interop) {
            return interop.accepts(obj);
        }

        abstract void executeWrite(Object var1, long var2, Object var4, ForeignToLLVM.ForeignToLLVMType var5);

        @Specialization(guards={"nativeLibrary.isPointer(receiver)", "!isWrappedAutoDerefHandle(language, nativeLibrary, receiver)"})
        static void doPointer(Object receiver, long offset, Object value, ForeignToLLVM.ForeignToLLVMType type, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMNativeLibrary nativeLibrary, @Cached LLVMMemoryWriteNode memoryWriteNode) {
            try {
                memoryWriteNode.executeWrite(nativeLibrary.asPointer(receiver) + offset, value);
            }
            catch (UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(ex);
            }
        }

        @Specialization(guards={"nativeLibrary.isPointer(receiver)", "isWrappedAutoDerefHandle(language, nativeLibrary, receiver)"})
        static void doTypedHandle(Object receiver, long offset, Object value, ForeignToLLVM.ForeignToLLVMType type, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @Cached.Shared(value="interopWrite") @Cached LLVMInteropWriteNode interopWrite, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMNativeLibrary nativeLibrary, @Cached LLVMDerefHandleGetReceiverNode receiverNode, @Cached LLVMAsForeignNode asForeignNode, @Cached.Shared(value="fallbackWrite") @Cached FallbackWriteNode fallbackWrite, @Cached(value="createBinaryProfile()") ConditionProfile typedWriteProfile) {
            try {
                LLVMManagedPointer recv = receiverNode.execute(nativeLibrary.asPointer(receiver));
                Object nativeType = nativeTypes.getNativeType(receiver);
                if (typedWriteProfile.profile(nativeType == null || nativeType instanceof LLVMInteropType.Structured)) {
                    interopWrite.execute((LLVMInteropType.Structured)nativeType, asForeignNode.execute(recv), recv.getOffset() + offset, value, type);
                } else {
                    fallbackWrite.executeWrite(recv.getObject(), offset, value, type);
                }
            }
            catch (UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(ex);
            }
        }

        @Specialization(guards={"!natives.isPointer(receiver)"})
        static void doValue(Object receiver, long offset, Object value, ForeignToLLVM.ForeignToLLVMType type, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @Cached.Shared(value="interopWrite") @Cached LLVMInteropWriteNode interopWrite, @CachedLibrary(limit="3") LLVMNativeLibrary natives, @Cached.Shared(value="fallbackWrite") @Cached FallbackWriteNode fallbackWrite, @Cached(value="createBinaryProfile()") ConditionProfile typedWriteProfile) {
            Object nativeType = nativeTypes.getNativeType(receiver);
            if (typedWriteProfile.profile(nativeType == null || nativeType instanceof LLVMInteropType.Structured)) {
                interopWrite.execute((LLVMInteropType.Structured)nativeType, receiver, offset, value, type);
            } else {
                fallbackWrite.executeWrite(receiver, offset, value, type);
            }
        }
    }

    @ExportLibrary(value=LLVMManagedWriteLibrary.class, receiverType=Object.class)
    static class FallbackWrite {
        FallbackWrite() {
        }

        @ExportMessage
        static boolean isWritable(Object obj, @Cached.Shared(value="write") @Cached ManagedWriteNode write, @CachedLibrary(limit="5") InteropLibrary interop) {
            return write.canAccess(obj, interop);
        }

        @ExportMessage
        static void writeI8(Object obj, long offset, byte value, @Cached.Shared(value="write") @Cached ManagedWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.I8);
        }

        @ExportMessage
        static void writeI16(Object obj, long offset, short value, @Cached.Shared(value="write") @Cached ManagedWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.I16);
        }

        @ExportMessage
        static void writeI32(Object obj, long offset, int value, @Cached.Shared(value="write") @Cached ManagedWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.I32);
        }

        @ExportMessage
        static void writeGenericI64(Object obj, long offset, Object value, @Cached.Shared(value="write") @Cached ManagedWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.I64);
        }

        @ExportMessage
        static void writeFloat(Object obj, long offset, float value, @Cached.Shared(value="write") @Cached ManagedWriteNode write) {
            write.executeWrite(obj, offset, Float.valueOf(value), ForeignToLLVM.ForeignToLLVMType.FLOAT);
        }

        @ExportMessage
        static void writeDouble(Object obj, long offset, double value, @Cached.Shared(value="write") @Cached ManagedWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.DOUBLE);
        }

        @ExportMessage
        static void writePointer(Object obj, long offset, LLVMPointer value, @Cached.Shared(value="write") @Cached ManagedWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.POINTER);
        }
    }

    static final class FallbackReadNode
    extends LLVMNode {
        @Node.Child
        private InteropLibrary interop;
        @Node.Child
        private ToLLVM toLLVM;

        private FallbackReadNode(boolean uncached) {
            if (uncached) {
                this.interop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
                this.toLLVM = ToLLVMNodeGen.getUncached();
            } else {
                this.interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
                this.toLLVM = ToLLVMNodeGen.create();
            }
        }

        public static FallbackReadNode create() {
            return new FallbackReadNode(false);
        }

        public static FallbackReadNode createUncached() {
            return new FallbackReadNode(true);
        }

        public Object executeRead(Object obj, long offset, ForeignToLLVM.ForeignToLLVMType type) {
            try {
                Object foreign = this.interop.readArrayElement(obj, offset / (long)type.getSizeInBytes());
                return this.toLLVM.executeWithType(foreign, null, type);
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }

    @GenerateUncached
    static abstract class ManagedReadNode
    extends ManagedAccessNode {
        ManagedReadNode() {
        }

        abstract Object executeRead(Object var1, long var2, ForeignToLLVM.ForeignToLLVMType var4);

        @Specialization(guards={"nativeLibrary.isPointer(receiver)", "!isWrappedAutoDerefHandle(language, nativeLibrary, receiver)"})
        Object doPointer(Object receiver, long offset, ForeignToLLVM.ForeignToLLVMType type, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMNativeLibrary nativeLibrary, @Cached(value="createIdentityProfile()") ValueProfile typeProfile) {
            try {
                long addr = nativeLibrary.asPointer(receiver) + offset;
                switch ((ForeignToLLVM.ForeignToLLVMType)((Object)typeProfile.profile((Object)type))) {
                    case I8: {
                        return language.getLLVMMemory().getI8((Node)this, addr);
                    }
                    case I16: {
                        return language.getLLVMMemory().getI16((Node)this, addr);
                    }
                    case I32: {
                        return language.getLLVMMemory().getI32((Node)this, addr);
                    }
                    case I64: {
                        return language.getLLVMMemory().getI64((Node)this, addr);
                    }
                    case FLOAT: {
                        return Float.valueOf(language.getLLVMMemory().getFloat((Node)this, addr));
                    }
                    case DOUBLE: {
                        return language.getLLVMMemory().getDouble((Node)this, addr);
                    }
                    case POINTER: {
                        return language.getLLVMMemory().getPointer((Node)this, addr);
                    }
                }
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("Unsupported type " + (Object)((Object)type));
            }
            catch (UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(ex);
            }
        }

        @Specialization(guards={"natives.isPointer(receiver)", "isWrappedAutoDerefHandle(language, natives, receiver)"})
        static Object doHandle(Object receiver, long offset, ForeignToLLVM.ForeignToLLVMType type, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMNativeLibrary natives, @Cached LLVMDerefHandleGetReceiverNode receiverNode, @Cached LLVMAsForeignNode asForeignNode, @Cached.Shared(value="fallbackRead") @Cached(value="create()", uncached="createUncached()") FallbackReadNode fallbackRead, @Cached(value="createBinaryProfile()") ConditionProfile typedReadProfile) {
            try {
                LLVMManagedPointer recv = receiverNode.execute(natives.asPointer(receiver));
                Object nativeType = nativeTypes.getNativeType(receiver);
                if (typedReadProfile.profile(nativeType == null || nativeType instanceof LLVMInteropType.Structured)) {
                    return read.execute((LLVMInteropType.Structured)nativeType, asForeignNode.execute(recv), recv.getOffset() + offset, type);
                }
                return fallbackRead.executeRead(recv.getObject(), offset, type);
            }
            catch (UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(ex);
            }
        }

        @Specialization(guards={"!natives.isPointer(receiver)"})
        static Object doValue(Object receiver, long offset, ForeignToLLVM.ForeignToLLVMType type, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @CachedLibrary(limit="3") LLVMNativeLibrary natives, @Cached.Shared(value="fallbackRead") @Cached(value="create()", uncached="createUncached()") FallbackReadNode fallbackRead, @Cached(value="createBinaryProfile()") ConditionProfile typedReadProfile) {
            Object nativeType = nativeTypes.getNativeType(receiver);
            if (typedReadProfile.profile(nativeType == null || nativeType instanceof LLVMInteropType.Structured)) {
                return read.execute((LLVMInteropType.Structured)nativeType, receiver, offset, type);
            }
            return fallbackRead.executeRead(receiver, offset, type);
        }
    }

    static abstract class ManagedAccessNode
    extends LLVMNode {
        ManagedAccessNode() {
        }

        static boolean isWrappedAutoDerefHandle(LLVMLanguage language, LLVMNativeLibrary nativeLibrary, Object obj) {
            try {
                return LLVMNode.isAutoDerefHandle(language, nativeLibrary.asPointer(obj));
            }
            catch (UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(ex);
            }
        }
    }

    @ExportLibrary(value=LLVMManagedReadLibrary.class, receiverType=Object.class)
    static class FallbackRead {
        FallbackRead() {
        }

        @ExportMessage
        static boolean isReadable(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) {
            return interop.accepts(obj);
        }

        @ExportMessage
        static byte readI8(Object obj, long offset, @Cached.Shared(value="read") @Cached ManagedReadNode read) {
            return LLVMTypesGen.asByte(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.I8));
        }

        @ExportMessage
        static short readI16(Object obj, long offset, @Cached.Shared(value="read") @Cached ManagedReadNode read) {
            ForeignToLLVM.ForeignToLLVMType type = ForeignToLLVM.ForeignToLLVMType.I16;
            return LLVMTypesGen.asShort(read.executeRead(obj, offset, type));
        }

        @ExportMessage
        static int readI32(Object obj, long offset, @Cached.Shared(value="read") @Cached ManagedReadNode read) {
            return LLVMTypesGen.asInteger(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.I32));
        }

        @ExportMessage
        static Object readGenericI64(Object obj, long offset, @Cached.Shared(value="read") @Cached ManagedReadNode read) {
            return read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.I64);
        }

        @ExportMessage
        static float readFloat(Object obj, long offset, @Cached.Shared(value="read") @Cached ManagedReadNode read) {
            return LLVMTypesGen.asFloat(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.FLOAT));
        }

        @ExportMessage
        static double readDouble(Object obj, long offset, @Cached.Shared(value="read") @Cached ManagedReadNode read) {
            return LLVMTypesGen.asDouble(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.DOUBLE));
        }

        @ExportMessage
        static LLVMPointer readPointer(Object obj, long offset, @Cached LLVMToPointerNode toPointer, @Cached.Shared(value="read") @Cached ManagedReadNode read) {
            return toPointer.executeWithTarget(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.POINTER));
        }
    }
}

