/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;

public abstract class LLVMDataEscapeNode
extends LLVMNode {
    public static LLVMDataEscapeNode create(Type type) {
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMDataEscapeNodeFactory.LLVMI1DataEscapeNodeGen.create();
                }
                case I8: {
                    return LLVMDataEscapeNodeFactory.LLVMI8DataEscapeNodeGen.create();
                }
                case I16: {
                    return LLVMDataEscapeNodeFactory.LLVMI16DataEscapeNodeGen.create();
                }
                case I32: {
                    return LLVMDataEscapeNodeFactory.LLVMI32DataEscapeNodeGen.create();
                }
                case I64: {
                    return LLVMDataEscapeNodeFactory.LLVMI64DataEscapeNodeGen.create();
                }
                case FLOAT: {
                    return LLVMDataEscapeNodeFactory.LLVMFloatDataEscapeNodeGen.create();
                }
                case DOUBLE: {
                    return LLVMDataEscapeNodeFactory.LLVMDoubleDataEscapeNodeGen.create();
                }
            }
            throw new AssertionError((Object)("unexpected type in LLVMDataEscapeNode: " + type));
        }
        if (type instanceof VoidType) {
            return LLVMDataEscapeNodeFactory.LLVMVoidDataEscapeNodeGen.create();
        }
        assert (type instanceof PointerType || type instanceof FunctionType) : "unexpected type in LLVMDataEscapeNode: " + type;
        return LLVMDataEscapeNodeFactory.LLVMPointerDataEscapeNodeGen.create();
    }

    public static LLVMDataEscapeNode create(ForeignToLLVM.ForeignToLLVMType type) {
        switch (type) {
            case I1: {
                return LLVMDataEscapeNodeFactory.LLVMI1DataEscapeNodeGen.create();
            }
            case I8: {
                return LLVMDataEscapeNodeFactory.LLVMI8DataEscapeNodeGen.create();
            }
            case I16: {
                return LLVMDataEscapeNodeFactory.LLVMI16DataEscapeNodeGen.create();
            }
            case I32: {
                return LLVMDataEscapeNodeFactory.LLVMI32DataEscapeNodeGen.create();
            }
            case I64: {
                return LLVMDataEscapeNodeFactory.LLVMI64DataEscapeNodeGen.create();
            }
            case FLOAT: {
                return LLVMDataEscapeNodeFactory.LLVMFloatDataEscapeNodeGen.create();
            }
            case DOUBLE: {
                return LLVMDataEscapeNodeFactory.LLVMDoubleDataEscapeNodeGen.create();
            }
            case POINTER: {
                return LLVMDataEscapeNodeFactory.LLVMPointerDataEscapeNodeGen.create();
            }
            case VOID: {
                return LLVMDataEscapeNodeFactory.LLVMVoidDataEscapeNodeGen.create();
            }
        }
        throw new AssertionError((Object)("unexpected type in LLVMDataEscapeNode: " + (Object)((Object)type)));
    }

    public static LLVMDataEscapeNode getUncached(ForeignToLLVM.ForeignToLLVMType type) {
        switch (type) {
            case I1: {
                return LLVMDataEscapeNodeFactory.LLVMI1DataEscapeNodeGen.getUncached();
            }
            case I8: {
                return LLVMDataEscapeNodeFactory.LLVMI8DataEscapeNodeGen.getUncached();
            }
            case I16: {
                return LLVMDataEscapeNodeFactory.LLVMI16DataEscapeNodeGen.getUncached();
            }
            case I32: {
                return LLVMDataEscapeNodeFactory.LLVMI32DataEscapeNodeGen.getUncached();
            }
            case I64: {
                return LLVMDataEscapeNodeFactory.LLVMI64DataEscapeNodeGen.getUncached();
            }
            case FLOAT: {
                return LLVMDataEscapeNodeFactory.LLVMFloatDataEscapeNodeGen.getUncached();
            }
            case DOUBLE: {
                return LLVMDataEscapeNodeFactory.LLVMDoubleDataEscapeNodeGen.getUncached();
            }
            case POINTER: {
                return LLVMDataEscapeNodeFactory.LLVMPointerDataEscapeNodeGen.getUncached();
            }
            case VOID: {
                return LLVMDataEscapeNodeFactory.LLVMVoidDataEscapeNodeGen.getUncached();
            }
        }
        throw new AssertionError((Object)("unexpected type in LLVMDataEscapeNode: " + (Object)((Object)type)));
    }

    public final Object executeWithTarget(Object escapingValue) {
        return this.executeWithType(escapingValue, null);
    }

    public abstract Object executeWithType(Object var1, LLVMInteropType.Structured var2);

    @GenerateUncached
    public static abstract class LLVMVoidDataEscapeNode
    extends LLVMDataEscapeNode {
        @Specialization
        public Object doVoid(LLVMPointer escapingValue, LLVMInteropType.Structured type) {
            assert (escapingValue.isNull());
            return escapingValue;
        }
    }

    @GenerateUncached
    @ReportPolymorphism
    public static abstract class LLVMPointerDataEscapeNode
    extends LLVMDataEscapeNode {
        @Specialization
        static String escapingString(String escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }

        @Specialization
        static Object escapingType(LLVMInteropType escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }

        static boolean isPrimitiveValue(Object object) {
            return object instanceof Long || object instanceof Double;
        }

        @Specialization(guards={"!isPrimitiveValue(object)", "foreigns.isForeign(object)"}, limit="3")
        static Object escapingForeignNonPointer(Object object, LLVMInteropType.Structured type, @CachedLibrary(value="object") LLVMAsForeignLibrary foreigns) {
            return foreigns.asForeign(object);
        }

        @Specialization(guards={"!foreigns.isForeign(address)"}, limit="3")
        static Object escapingManaged(LLVMPointer address, LLVMInteropType.Structured type, @CachedLibrary(value="address") LLVMAsForeignLibrary foreigns, @Cached ConditionProfile typedProfile) {
            if (typedProfile.profile(address.getExportType() != null)) {
                return address;
            }
            return address.export(type);
        }

        @Specialization
        static LLVMPointer escapingPrimitive(long escapingValue, LLVMInteropType.Structured type) {
            return LLVMNativePointer.create(escapingValue).export(type);
        }

        @Specialization
        static LLVMPointer escapingPrimitive(double escapingValue, LLVMInteropType.Structured type) {
            return LLVMNativePointer.create(Double.doubleToRawLongBits(escapingValue)).export(type);
        }
    }

    @GenerateUncached
    public static abstract class LLVMDoubleDataEscapeNode
    extends LLVMDataEscapeNode {
        @Specialization
        static double escapingPrimitive(double escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }

        @Specialization
        static double escapingLong(long escapingValue, LLVMInteropType.Structured type) {
            return Double.longBitsToDouble(escapingValue);
        }

        @Specialization(limit="3", replaces={"escapingLong"})
        static double escapingPointer(Object escapingValue, LLVMInteropType.Structured type, @CachedLibrary(value="escapingValue") LLVMNativeLibrary library) {
            return LLVMDoubleDataEscapeNode.escapingLong(library.toNativePointer(escapingValue).asNative(), type);
        }
    }

    @GenerateUncached
    public static abstract class LLVMFloatDataEscapeNode
    extends LLVMDataEscapeNode {
        @Specialization
        static float escapingPrimitive(float escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }

        @Specialization
        static float escapingPrimitive(int escapingValue, LLVMInteropType.Structured type) {
            return Float.intBitsToFloat(escapingValue);
        }
    }

    @GenerateUncached
    public static abstract class LLVMI64DataEscapeNode
    extends LLVMDataEscapeNode {
        public final long executeWithTargetI64(Object escapingValue) {
            return this.executeWithTypeI64(escapingValue, null);
        }

        public abstract long executeWithTypeI64(Object var1, LLVMInteropType.Structured var2);

        @Specialization
        static long escapingPrimitive(long escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }

        @Specialization
        static long escapingPrimitive(double escapingValue, LLVMInteropType.Structured type) {
            return Double.doubleToRawLongBits(escapingValue);
        }

        @Specialization
        static long escapingNativePointer(LLVMNativePointer escapingValue, LLVMInteropType.Structured type) {
            return escapingValue.asNative();
        }

        @Specialization
        static Object escapingPointer(LLVMManagedPointer escapingValue, LLVMInteropType.Structured type, @Cached LLVMPointerDataEscapeNode pointerDataEscapeNode) {
            return pointerDataEscapeNode.executeWithType(escapingValue, type);
        }
    }

    @GenerateUncached
    public static abstract class LLVMI32DataEscapeNode
    extends LLVMDataEscapeNode {
        public final int executeWithTargetI32(Object escapingValue) {
            return this.executeWithTypeI32(escapingValue, null);
        }

        public abstract int executeWithTypeI32(Object var1, LLVMInteropType.Structured var2);

        @Specialization
        static int escapingPrimitive(int escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }

        @Specialization
        static int escapingPrimitive(float escapingValue, LLVMInteropType.Structured type) {
            return Float.floatToRawIntBits(escapingValue);
        }
    }

    @GenerateUncached
    public static abstract class LLVMI16DataEscapeNode
    extends LLVMDataEscapeNode {
        public final short executeWithTargetI16(Object escapingValue) {
            return this.executeWithTypeI16(escapingValue, null);
        }

        public abstract short executeWithTypeI16(Object var1, LLVMInteropType.Structured var2);

        @Specialization
        static short escapingPrimitive(short escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }
    }

    @GenerateUncached
    public static abstract class LLVMI8DataEscapeNode
    extends LLVMDataEscapeNode {
        @Specialization
        static byte escapingPrimitive(byte escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }
    }

    @GenerateUncached
    public static abstract class LLVMI1DataEscapeNode
    extends LLVMDataEscapeNode {
        @Specialization
        static boolean escapingPrimitive(boolean escapingValue, LLVMInteropType.Structured type) {
            return escapingValue;
        }
    }
}

