/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.instruments.trace;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.llvm.runtime.instruments.trace.LLVMTraceNodeFactory;
import com.oracle.truffle.llvm.runtime.options.TargetStream;

public final class LLVMTracerInstrument {
    private final TargetStream targetStream;

    public LLVMTracerInstrument(TruffleLanguage.Env env, String optionString) {
        SourceSectionFilter.Builder builder = SourceSectionFilter.newBuilder();
        builder.mimeTypeIs(new String[]{"text/x-llvmir"});
        builder.tagIs(new Class[]{StandardTags.StatementTag.class, StandardTags.RootTag.class});
        SourceSectionFilter filter = builder.build();
        Instrumenter instrumenter = (Instrumenter)env.lookup(Instrumenter.class);
        if (instrumenter == null) {
            throw new IllegalStateException("Could not find Instrumenter");
        }
        this.targetStream = new TargetStream(env, optionString);
        instrumenter.attachExecutionEventFactory(filter, (ExecutionEventNodeFactory)new LLVMTraceNodeFactory(this.targetStream));
    }

    public void dispose() {
        this.targetStream.dispose();
    }
}

