/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.global;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObjectGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMGlobalContainer.class)
final class LLVMGlobalContainerGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);

    private LLVMGlobalContainerGen() {
    }

    static {
        LibraryExport.register(LLVMGlobalContainer.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports()});
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, LLVMGlobalContainer.class, false);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI8.writeNative(arg0Value, arg1Value, arg2Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI16.writeNative(arg0Value, arg1Value, arg2Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI32.writeNative(arg0Value, arg1Value, arg2Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, Float.valueOf(arg2Value)});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value, BranchProfile.getUncached(), BranchProfile.getUncached());
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg2Value), (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    LLVMGlobalContainer.WriteGenericI64.writeManaged(arg0Value, arg1Value, arg2Value, BranchProfile.getUncached(), BranchProfile.getUncached());
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile p1;
            @CompilerDirectives.CompilationFinal
            private BranchProfile p2;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
            @Node.Child
            private WriteGenericI64WriteNative0Data writeGenericI64_writeNative0_cache;

            protected Cached(Object receiver) {
                LLVMGlobalContainer castReceiver = (LLVMGlobalContainer)receiver;
                this.receiverInteropLibrary_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create((Object)castReceiver)));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMGlobalContainer)) {
                    return false;
                }
                return this.receiverInteropLibrary_.accepts(receiver);
            }

            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value.isPointer()) {
                        Cached writeI8_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage writeI8_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        LLVMGlobalContainer.WriteI8.writeNative(arg0Value, arg1Value, arg2Value, writeI8_writeNative_location__, writeI8_writeNative_language__);
                        return;
                    }
                    if ((state_0 & 2) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary writeI8_writeManaged_interop__ = this.receiverInteropLibrary_;
                        Cached writeI8_writeManaged_write__ = this;
                        LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, writeI8_writeManaged_interop__, writeI8_writeManaged_write__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI8AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI8AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, byte arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage writeI8_writeNative_language__ = null;
                    Cached writeI8_writeNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        writeI8_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        writeI8_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI8.writeNative(arg0Value, arg1Value, arg2Value, writeI8_writeNative_location__, writeI8_writeNative_language__);
                        return;
                    }
                    Cached writeI8_writeManaged_write__ = null;
                    InteropLibrary writeI8_writeManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        writeI8_writeManaged_interop__ = this.receiverInteropLibrary_;
                        writeI8_writeManaged_write__ = this;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, writeI8_writeManaged_interop__, writeI8_writeManaged_write__);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && arg0Value.isPointer()) {
                        Cached writeI16_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage writeI16_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        LLVMGlobalContainer.WriteI16.writeNative(arg0Value, arg1Value, arg2Value, writeI16_writeNative_location__, writeI16_writeNative_language__);
                        return;
                    }
                    if ((state_0 & 8) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary writeI16_writeManaged_interop__ = this.receiverInteropLibrary_;
                        Cached writeI16_writeManaged_write__ = this;
                        LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, writeI16_writeManaged_interop__, writeI16_writeManaged_write__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI16AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI16AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, short arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage writeI16_writeNative_language__ = null;
                    Cached writeI16_writeNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        writeI16_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        writeI16_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI16.writeNative(arg0Value, arg1Value, arg2Value, writeI16_writeNative_location__, writeI16_writeNative_language__);
                        return;
                    }
                    Cached writeI16_writeManaged_write__ = null;
                    InteropLibrary writeI16_writeManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        writeI16_writeManaged_interop__ = this.receiverInteropLibrary_;
                        writeI16_writeManaged_write__ = this;
                        this.state_0_ = state_0 |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, writeI16_writeManaged_interop__, writeI16_writeManaged_write__);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x30) != 0) {
                    if ((state_0 & 0x10) != 0 && arg0Value.isPointer()) {
                        Cached writeI32_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage writeI32_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        LLVMGlobalContainer.WriteI32.writeNative(arg0Value, arg1Value, arg2Value, writeI32_writeNative_location__, writeI32_writeNative_language__);
                        return;
                    }
                    if ((state_0 & 0x20) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary writeI32_writeManaged_interop__ = this.receiverInteropLibrary_;
                        Cached writeI32_writeManaged_write__ = this;
                        LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, writeI32_writeManaged_interop__, writeI32_writeManaged_write__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI32AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI32AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, int arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage writeI32_writeNative_language__ = null;
                    Cached writeI32_writeNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        writeI32_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        writeI32_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI32.writeNative(arg0Value, arg1Value, arg2Value, writeI32_writeNative_location__, writeI32_writeNative_language__);
                        return;
                    }
                    Cached writeI32_writeManaged_write__ = null;
                    InteropLibrary writeI32_writeManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        writeI32_writeManaged_interop__ = this.receiverInteropLibrary_;
                        writeI32_writeManaged_write__ = this;
                        this.state_0_ = state_0 |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, writeI32_writeManaged_interop__, writeI32_writeManaged_write__);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC0) != 0) {
                    if ((state_0 & 0x40) != 0 && arg0Value.isPointer()) {
                        Cached writeFloat_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage writeFloat_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        LLVMGlobalContainer.WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, writeFloat_writeNative_location__, writeFloat_writeNative_language__);
                        return;
                    }
                    if ((state_0 & 0x80) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary writeFloat_writeManaged_interop__ = this.receiverInteropLibrary_;
                        Cached writeFloat_writeManaged_write__ = this;
                        LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, writeFloat_writeManaged_interop__, writeFloat_writeManaged_write__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeFloatAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeFloatAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, float arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage writeFloat_writeNative_language__ = null;
                    Cached writeFloat_writeNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        writeFloat_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        writeFloat_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, writeFloat_writeNative_location__, writeFloat_writeNative_language__);
                        return;
                    }
                    Cached writeFloat_writeManaged_write__ = null;
                    InteropLibrary writeFloat_writeManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        writeFloat_writeManaged_interop__ = this.receiverInteropLibrary_;
                        writeFloat_writeManaged_write__ = this;
                        this.state_0_ = state_0 |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, writeFloat_writeManaged_interop__, writeFloat_writeManaged_write__);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, Float.valueOf(arg2Value)});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x300) != 0) {
                    if ((state_0 & 0x100) != 0 && arg0Value.isPointer()) {
                        Cached writeDouble_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage writeDouble_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        LLVMGlobalContainer.WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, writeDouble_writeNative_location__, writeDouble_writeNative_language__);
                        return;
                    }
                    if ((state_0 & 0x200) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary writeDouble_writeManaged_interop__ = this.receiverInteropLibrary_;
                        Cached writeDouble_writeManaged_write__ = this;
                        LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, writeDouble_writeManaged_interop__, writeDouble_writeManaged_write__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeDoubleAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeDoubleAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, double arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage writeDouble_writeNative_language__ = null;
                    Cached writeDouble_writeNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        writeDouble_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        writeDouble_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x100;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, writeDouble_writeNative_location__, writeDouble_writeNative_language__);
                        return;
                    }
                    Cached writeDouble_writeManaged_write__ = null;
                    InteropLibrary writeDouble_writeManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        writeDouble_writeManaged_interop__ = this.receiverInteropLibrary_;
                        writeDouble_writeManaged_write__ = this;
                        this.state_0_ = state_0 |= 0x200;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, writeDouble_writeManaged_interop__, writeDouble_writeManaged_write__);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1C00) != 0) {
                    if ((state_0 & 0x400) != 0 && arg0Value.isPointer()) {
                        Cached writeI64_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage writeI64_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, writeI64_writeNative_location__, writeI64_writeNative_language__);
                        return;
                    }
                    if ((state_0 & 0x800) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value, this.p1, this.p2);
                        return;
                    }
                    if ((state_0 & 0x1000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        InteropLibrary writeI64_writeFallback_interop__ = this.receiverInteropLibrary_;
                        Cached writeI64_writeFallback_write__ = this;
                        LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, writeI64_writeFallback_interop__, writeI64_writeFallback_write__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI64AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, long arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage writeI64_writeNative_language__ = null;
                    Cached writeI64_writeNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        writeI64_writeNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        writeI64_writeNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x400;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, writeI64_writeNative_location__, writeI64_writeNative_language__);
                        return;
                    }
                    if (!arg0Value.isPointer() && arg1Value == 0L) {
                        if (this.p1 == null) {
                            this.p1 = BranchProfile.create();
                        }
                        if (this.p2 == null) {
                            this.p2 = BranchProfile.create();
                        }
                        this.state_0_ = state_0 |= 0x800;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value, this.p1, this.p2);
                        return;
                    }
                    Cached writeI64_writeFallback_write__ = null;
                    InteropLibrary writeI64_writeFallback_interop__ = null;
                    if (!arg0Value.isPointer() && arg1Value != 0L) {
                        writeI64_writeFallback_interop__ = this.receiverInteropLibrary_;
                        writeI64_writeFallback_write__ = this;
                        this.state_0_ = state_0 |= 0x1000;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, writeI64_writeFallback_interop__, writeI64_writeFallback_write__);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            @ExplodeLoop
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1E000) != 0) {
                    if ((state_0 & 0x2000) != 0) {
                        WriteGenericI64WriteNative0Data s1_ = this.writeGenericI64_writeNative0_cache;
                        while (s1_ != null) {
                            if (s1_.toNative_.accepts(arg2Value) && arg0Value.isPointer()) {
                                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                                LLVMLanguage language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                                LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, s1_.toNative_, language__);
                                return;
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0x4000) != 0 && arg0Value.isPointer()) {
                        this.writeNative1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state_0 & 0x8000) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        LLVMGlobalContainer.WriteGenericI64.writeManaged(arg0Value, arg1Value, arg2Value, this.p1, this.p2);
                        return;
                    }
                    if ((state_0 & 0x10000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        InteropLibrary writeGenericI64_writeFallback_interop__ = this.receiverInteropLibrary_;
                        Cached writeGenericI64_writeFallback_write__ = this;
                        LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, writeGenericI64_writeFallback_interop__, writeGenericI64_writeFallback_write__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private void writeNative1Boundary(int state_0, LLVMGlobalContainer arg0Value, long arg1Value, Object arg2Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    LLVMNativeLibrary writeGenericI64_writeNative1_toNative__ = (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg2Value);
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                    LLVMLanguage writeGenericI64_writeNative1_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                    LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, writeGenericI64_writeNative1_toNative__, writeGenericI64_writeNative1_language__);
                    return;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeGenericI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, Object arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    LLVMLanguage language__ = null;
                    if (exclude == 0) {
                        int count1_ = 0;
                        WriteGenericI64WriteNative0Data s1_ = this.writeGenericI64_writeNative0_cache;
                        if ((state_0 & 0x2000) != 0) {
                            while (s1_ != null) {
                                if (s1_.toNative_.accepts(arg2Value) && arg0Value.isPointer()) {
                                    TruffleLanguage.LanguageReference lLVMLanguageReference__2 = this.lLVMLanguageReference_;
                                    if (lLVMLanguageReference__2 == null) {
                                        this.lLVMLanguageReference_ = lLVMLanguageReference__2 = super.lookupLanguageReference(LLVMLanguage.class);
                                    }
                                    language__ = (LLVMLanguage)lLVMLanguageReference__2.get();
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && arg0Value.isPointer() && count1_ < 3) {
                            s1_ = (WriteGenericI64WriteNative0Data)super.insert((Node)new WriteGenericI64WriteNative0Data(this.writeGenericI64_writeNative0_cache));
                            s1_.toNative_ = s1_.insertAccessor((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.create(arg2Value));
                            TruffleLanguage.LanguageReference lLVMLanguageReference__3 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__3 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__3 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            language__ = (LLVMLanguage)lLVMLanguageReference__3.get();
                            this.writeGenericI64_writeNative0_cache = s1_;
                            this.state_0_ = state_0 |= 0x2000;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, s1_.toNative_, language__);
                            return;
                        }
                    }
                    LLVMLanguage writeGenericI64_writeNative1_language__ = null;
                    LLVMNativeLibrary writeGenericI64_writeNative1_toNative__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        if (arg0Value.isPointer()) {
                            writeGenericI64_writeNative1_toNative__ = (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg2Value);
                            TruffleLanguage.LanguageReference lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__4 == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__4 = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            writeGenericI64_writeNative1_language__ = (LLVMLanguage)lLVMLanguageReference__4.get();
                            this.exclude_ = exclude |= 1;
                            this.writeGenericI64_writeNative0_cache = null;
                            state_0 &= 0xFFFFDFFF;
                            this.state_0_ = state_0 |= 0x4000;
                            lock.unlock();
                            hasLock = false;
                            LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, writeGenericI64_writeNative1_toNative__, writeGenericI64_writeNative1_language__);
                            return;
                        }
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                    if (!arg0Value.isPointer() && arg1Value == 0L) {
                        if (this.p1 == null) {
                            this.p1 = BranchProfile.create();
                        }
                        if (this.p2 == null) {
                            this.p2 = BranchProfile.create();
                        }
                        this.state_0_ = state_0 |= 0x8000;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteGenericI64.writeManaged(arg0Value, arg1Value, arg2Value, this.p1, this.p2);
                        return;
                    }
                    Cached writeGenericI64_writeFallback_write__ = null;
                    InteropLibrary writeGenericI64_writeFallback_interop__ = null;
                    if (!arg0Value.isPointer() && arg1Value != 0L) {
                        writeGenericI64_writeFallback_interop__ = this.receiverInteropLibrary_;
                        writeGenericI64_writeFallback_write__ = this;
                        this.state_0_ = state_0 |= 0x10000;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, writeGenericI64_writeFallback_interop__, writeGenericI64_writeFallback_write__);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (receiver instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }

            @GeneratedBy(value=LLVMGlobalContainer.class)
            private static final class WriteGenericI64WriteNative0Data
            extends Node {
                @Node.Child
                WriteGenericI64WriteNative0Data next_;
                @Node.Child
                LLVMNativeLibrary toNative_;

                WriteGenericI64WriteNative0Data(WriteGenericI64WriteNative0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, LLVMGlobalContainer.class, false);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI8.readNative(arg0Value, arg1Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI16.readNative(arg0Value, arg1Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI32.readNative(arg0Value, arg1Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadFloat.readNative(arg0Value, arg1Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadDouble.readNative(arg0Value, arg1Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    return LLVMGlobalContainer.ReadGenericI64.readManaged(arg0Value, arg1Value);
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    return LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, this, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    return LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, LLVMToPointerNodeGen.getUncached());
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    return LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
            @Node.Child
            private LLVMToPointerNode readPointer_readManaged_toPointer_;

            protected Cached(Object receiver) {
                LLVMGlobalContainer castReceiver = (LLVMGlobalContainer)receiver;
                this.receiverInteropLibrary_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create((Object)castReceiver)));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMGlobalContainer)) {
                    return false;
                }
                return this.receiverInteropLibrary_.accepts(receiver);
            }

            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value.isPointer()) {
                        Cached readI8_readNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage readI8_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        return LLVMGlobalContainer.ReadI8.readNative(arg0Value, arg1Value, readI8_readNative_location__, readI8_readNative_language__);
                    }
                    if ((state_0 & 2) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary readI8_readManaged_interop__ = this.receiverInteropLibrary_;
                        Cached readI8_readManaged_read__ = this;
                        return LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, readI8_readManaged_interop__, readI8_readManaged_read__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8AndSpecialize(arg0Value, arg1Value);
            }

            private byte readI8AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage readI8_readNative_language__ = null;
                    Cached readI8_readNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        readI8_readNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        readI8_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        byte by = LLVMGlobalContainer.ReadI8.readNative(arg0Value, arg1Value, readI8_readNative_location__, readI8_readNative_language__);
                        return by;
                    }
                    Cached readI8_readManaged_read__ = null;
                    InteropLibrary readI8_readManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        readI8_readManaged_interop__ = this.receiverInteropLibrary_;
                        readI8_readManaged_read__ = this;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        byte by = LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, readI8_readManaged_interop__, readI8_readManaged_read__);
                        return by;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && arg0Value.isPointer()) {
                        Cached readI16_readNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage readI16_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        return LLVMGlobalContainer.ReadI16.readNative(arg0Value, arg1Value, readI16_readNative_location__, readI16_readNative_language__);
                    }
                    if ((state_0 & 8) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary readI16_readManaged_interop__ = this.receiverInteropLibrary_;
                        Cached readI16_readManaged_read__ = this;
                        return LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, readI16_readManaged_interop__, readI16_readManaged_read__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16AndSpecialize(arg0Value, arg1Value);
            }

            private short readI16AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage readI16_readNative_language__ = null;
                    Cached readI16_readNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        readI16_readNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        readI16_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        short s = LLVMGlobalContainer.ReadI16.readNative(arg0Value, arg1Value, readI16_readNative_location__, readI16_readNative_language__);
                        return s;
                    }
                    Cached readI16_readManaged_read__ = null;
                    InteropLibrary readI16_readManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        readI16_readManaged_interop__ = this.receiverInteropLibrary_;
                        readI16_readManaged_read__ = this;
                        this.state_0_ = state_0 |= 8;
                        lock.unlock();
                        hasLock = false;
                        short s = LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, readI16_readManaged_interop__, readI16_readManaged_read__);
                        return s;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x30) != 0) {
                    if ((state_0 & 0x10) != 0 && arg0Value.isPointer()) {
                        Cached readI32_readNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage readI32_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        return LLVMGlobalContainer.ReadI32.readNative(arg0Value, arg1Value, readI32_readNative_location__, readI32_readNative_language__);
                    }
                    if ((state_0 & 0x20) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary readI32_readManaged_interop__ = this.receiverInteropLibrary_;
                        Cached readI32_readManaged_read__ = this;
                        return LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, readI32_readManaged_interop__, readI32_readManaged_read__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32AndSpecialize(arg0Value, arg1Value);
            }

            private int readI32AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage readI32_readNative_language__ = null;
                    Cached readI32_readNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        readI32_readNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        readI32_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        int n = LLVMGlobalContainer.ReadI32.readNative(arg0Value, arg1Value, readI32_readNative_location__, readI32_readNative_language__);
                        return n;
                    }
                    Cached readI32_readManaged_read__ = null;
                    InteropLibrary readI32_readManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        readI32_readManaged_interop__ = this.receiverInteropLibrary_;
                        readI32_readManaged_read__ = this;
                        this.state_0_ = state_0 |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        int n = LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, readI32_readManaged_interop__, readI32_readManaged_read__);
                        return n;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC0) != 0) {
                    if ((state_0 & 0x40) != 0 && arg0Value.isPointer()) {
                        Cached readFloat_readNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage readFloat_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        return LLVMGlobalContainer.ReadFloat.readNative(arg0Value, arg1Value, readFloat_readNative_location__, readFloat_readNative_language__);
                    }
                    if ((state_0 & 0x80) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary readFloat_readManaged_interop__ = this.receiverInteropLibrary_;
                        Cached readFloat_readManaged_read__ = this;
                        return LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, readFloat_readManaged_interop__, readFloat_readManaged_read__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatAndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage readFloat_readNative_language__ = null;
                    Cached readFloat_readNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        readFloat_readNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        readFloat_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        float f = LLVMGlobalContainer.ReadFloat.readNative(arg0Value, arg1Value, readFloat_readNative_location__, readFloat_readNative_language__);
                        return f;
                    }
                    Cached readFloat_readManaged_read__ = null;
                    InteropLibrary readFloat_readManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        readFloat_readManaged_interop__ = this.receiverInteropLibrary_;
                        readFloat_readManaged_read__ = this;
                        this.state_0_ = state_0 |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        float f = LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, readFloat_readManaged_interop__, readFloat_readManaged_read__);
                        return f;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x300) != 0) {
                    if ((state_0 & 0x100) != 0 && arg0Value.isPointer()) {
                        Cached readDouble_readNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage readDouble_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        return LLVMGlobalContainer.ReadDouble.readNative(arg0Value, arg1Value, readDouble_readNative_location__, readDouble_readNative_language__);
                    }
                    if ((state_0 & 0x200) != 0 && !arg0Value.isPointer()) {
                        InteropLibrary readDouble_readManaged_interop__ = this.receiverInteropLibrary_;
                        Cached readDouble_readManaged_read__ = this;
                        return LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, readDouble_readManaged_interop__, readDouble_readManaged_read__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleAndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMLanguage readDouble_readNative_language__ = null;
                    Cached readDouble_readNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        readDouble_readNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        readDouble_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x100;
                        lock.unlock();
                        hasLock = false;
                        double d = LLVMGlobalContainer.ReadDouble.readNative(arg0Value, arg1Value, readDouble_readNative_location__, readDouble_readNative_language__);
                        return d;
                    }
                    Cached readDouble_readManaged_read__ = null;
                    InteropLibrary readDouble_readManaged_interop__ = null;
                    if (!arg0Value.isPointer()) {
                        readDouble_readManaged_interop__ = this.receiverInteropLibrary_;
                        readDouble_readManaged_read__ = this;
                        this.state_0_ = state_0 |= 0x200;
                        lock.unlock();
                        hasLock = false;
                        double d = LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, readDouble_readManaged_interop__, readDouble_readManaged_read__);
                        return d;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1C00) != 0) {
                    if ((state_0 & 0x400) != 0 && arg0Value.isPointer()) {
                        Cached readGenericI64_readNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage readGenericI64_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        return LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, readGenericI64_readNative_location__, readGenericI64_readNative_language__);
                    }
                    if ((state_0 & 0x800) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        return LLVMGlobalContainer.ReadGenericI64.readManaged(arg0Value, arg1Value);
                    }
                    if ((state_0 & 0x1000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        InteropLibrary readGenericI64_readFallback_interop__ = this.receiverInteropLibrary_;
                        Cached readGenericI64_readFallback_read__ = this;
                        return LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, readGenericI64_readFallback_interop__, readGenericI64_readFallback_read__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readGenericI64AndSpecialize(arg0Value, arg1Value);
            }

            private Object readGenericI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    Object readGenericI64_readNative_language__ = null;
                    Cached readGenericI64_readNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        readGenericI64_readNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        readGenericI64_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x400;
                        lock.unlock();
                        hasLock = false;
                        Long l = LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, readGenericI64_readNative_location__, readGenericI64_readNative_language__);
                        return l;
                    }
                    if (!arg0Value.isPointer() && arg1Value == 0L) {
                        this.state_0_ = state_0 |= 0x800;
                        lock.unlock();
                        hasLock = false;
                        readGenericI64_readNative_language__ = LLVMGlobalContainer.ReadGenericI64.readManaged(arg0Value, arg1Value);
                        return readGenericI64_readNative_language__;
                    }
                    Cached readGenericI64_readFallback_read__ = null;
                    InteropLibrary readGenericI64_readFallback_interop__ = null;
                    if (!arg0Value.isPointer() && arg1Value != 0L) {
                        readGenericI64_readFallback_interop__ = this.receiverInteropLibrary_;
                        readGenericI64_readFallback_read__ = this;
                        this.state_0_ = state_0 |= 0x1000;
                        lock.unlock();
                        hasLock = false;
                        Object object = LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, readGenericI64_readFallback_interop__, readGenericI64_readFallback_read__);
                        return object;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xE000) != 0) {
                    if ((state_0 & 0x2000) != 0 && arg0Value.isPointer()) {
                        Cached readPointer_readNative_location__ = this;
                        TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        LLVMLanguage readPointer_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                        return LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, readPointer_readNative_location__, readPointer_readNative_language__);
                    }
                    if ((state_0 & 0x4000) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        return LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, this.readPointer_readManaged_toPointer_);
                    }
                    if ((state_0 & 0x8000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        InteropLibrary readPointer_readFallback_interop__ = this.receiverInteropLibrary_;
                        Cached readPointer_readFallback_read__ = this;
                        return LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, readPointer_readFallback_interop__, readPointer_readFallback_read__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerAndSpecialize(arg0Value, arg1Value);
            }

            private LLVMPointer readPointerAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    Object readPointer_readNative_language__ = null;
                    Cached readPointer_readNative_location__ = null;
                    if (arg0Value.isPointer()) {
                        readPointer_readNative_location__ = this;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__1 == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__1 = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        readPointer_readNative_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                        this.state_0_ = state_0 |= 0x2000;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, readPointer_readNative_location__, readPointer_readNative_language__);
                        return lLVMPointer;
                    }
                    if (!arg0Value.isPointer() && arg1Value == 0L) {
                        this.readPointer_readManaged_toPointer_ = (LLVMToPointerNode)super.insert((Node)LLVMToPointerNodeGen.create());
                        this.state_0_ = state_0 |= 0x4000;
                        lock.unlock();
                        hasLock = false;
                        readPointer_readNative_language__ = LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, this.readPointer_readManaged_toPointer_);
                        return readPointer_readNative_language__;
                    }
                    Cached readPointer_readFallback_read__ = null;
                    InteropLibrary readPointer_readFallback_interop__ = null;
                    if (!arg0Value.isPointer() && arg1Value != 0L) {
                        readPointer_readFallback_interop__ = this.receiverInteropLibrary_;
                        readPointer_readFallback_read__ = this;
                        this.state_0_ = state_0 |= 0x8000;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, readPointer_readFallback_interop__, readPointer_readFallback_read__);
                        return lLVMPointer;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (receiver instanceof LLVMGlobalContainer) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMGlobalContainer.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Uncached
        extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Uncached {
            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                arg0Value.toNative(LLVMToNativeNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Cached {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private LLVMToNativeNode toNative_;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMGlobalContainer)receiver).isPointer();
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMGlobalContainer)receiver).asPointer();
            }

            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    arg0Value.toNative(this.toNative_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void executeAndSpecialize(LLVMGlobalContainer arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    this.toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNodeGen.create());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.toNative(this.toNative_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

