/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.value;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceArrayLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceBasicType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourcePointerType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStructLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.OpaqueType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;

public final class LLVMSourceTypeFactory {
    public static LLVMSourceType resolveType(Type type, DataLayout dataLayout) {
        CompilerAsserts.neverPartOfCompilation();
        ConversionVisitor visitor = new ConversionVisitor(dataLayout);
        return visitor.resolveType(type);
    }

    private LLVMSourceTypeFactory() {
    }

    private static final class ConversionVisitor
    implements TypeVisitor {
        private final DataLayout dataLayout;
        private final Map<Type, LLVMSourceType> resolved;

        private ConversionVisitor(DataLayout dataLayout) {
            this.dataLayout = dataLayout;
            this.resolved = new IdentityHashMap<Type, LLVMSourceType>();
        }

        LLVMSourceType resolveType(Type type) {
            if (type == null) {
                return null;
            }
            LLVMSourceType previouslyResolved = this.resolved.get(type);
            if (previouslyResolved != null) {
                return previouslyResolved;
            }
            type.accept(this);
            return this.resolved.get(type);
        }

        @Override
        public void visit(FunctionType type) {
            ArrayList<LLVMSourceType> types = new ArrayList<LLVMSourceType>();
            LLVMSourceFunctionType resolvedType = new LLVMSourceFunctionType(types);
            this.resolved.put(type, resolvedType);
            LLVMSourceType resolvedReturnType = this.resolveType(type.getReturnType());
            types.add(resolvedReturnType);
            for (int i = 0; i < type.getNumberOfArguments(); ++i) {
                LLVMSourceType resolvedArgType = this.resolveType(type.getArgumentType(i));
                types.add(resolvedArgType);
            }
            if (type.isVarargs()) {
                types.add(LLVMSourceType.VOID);
            }
        }

        @Override
        public void visit(PrimitiveType type) {
            try {
                LLVMSourceType resolvedType;
                String name = type.getPrimitiveKind().name().toLowerCase();
                switch (type.getPrimitiveKind()) {
                    case I1: {
                        resolvedType = new LLVMSourceBasicType(name, this.getBitSize(type), this.getAlignment(type), 0L, LLVMSourceBasicType.Kind.BOOLEAN, null);
                        break;
                    }
                    case I8: 
                    case I16: 
                    case I32: 
                    case I64: {
                        resolvedType = new LLVMSourceBasicType(name, this.getBitSize(type), this.getAlignment(type), 0L, LLVMSourceBasicType.Kind.SIGNED, null);
                        break;
                    }
                    case FLOAT: 
                    case DOUBLE: 
                    case X86_FP80: {
                        resolvedType = new LLVMSourceBasicType(name, this.getBitSize(type), this.getAlignment(type), 0L, LLVMSourceBasicType.Kind.FLOATING, null);
                        break;
                    }
                    default: {
                        resolvedType = LLVMSourceType.UNSUPPORTED;
                    }
                }
                this.resolved.put(type, resolvedType);
            }
            catch (Type.TypeOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void visit(MetaType type) {
            throw new UnsupportedOperationException("Cannot convert type: " + type);
        }

        @Override
        public void visit(PointerType type) {
            try {
                LLVMSourcePointerType resolvedType = new LLVMSourcePointerType(this.getBitSize(type), this.getAlignment(type), 0L, false, false, null);
                this.resolved.put(type, resolvedType);
                Type baseType = type.getPointeeType();
                LLVMSourceType resolvedBaseType = baseType != null ? this.resolveType(baseType) : LLVMSourceType.VOID;
                resolvedType.setBaseType(resolvedBaseType);
                resolvedType.setName(() -> String.format("%s*", resolvedBaseType.getName()));
            }
            catch (Type.TypeOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void visit(StructureType type) {
            try {
                LLVMSourceStructLikeType resolvedType = new LLVMSourceStructLikeType(type.getName(), this.getBitSize(type), this.getAlignment(type), 0L, null);
                this.resolved.put(type, resolvedType);
                int numberOfMembers = type.getNumberOfElementsInt();
                for (int i = 0; i < numberOfMembers; ++i) {
                    Type memberType = type.getElementType(i);
                    long memberBitOffset = Type.multiplyUnsignedExact(type.getOffsetOf(i, this.dataLayout), 8L);
                    String memberName = String.format("[%d]", i);
                    LLVMSourceType resolvedMemberType = this.resolveType(memberType);
                    LLVMSourceMemberType member = new LLVMSourceMemberType(memberName, this.getBitSize(memberType), this.getAlignment(memberType), memberBitOffset, null);
                    member.setElementType(resolvedMemberType);
                    resolvedType.addDynamicMember(member);
                }
            }
            catch (Type.TypeOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void visit(ArrayType arrayType) {
            this.resolveArrayOrVectorType(arrayType);
        }

        @Override
        public void visit(VectorType vectorType) {
            this.resolveArrayOrVectorType(vectorType);
        }

        private void resolveArrayOrVectorType(AggregateType type) {
            try {
                LLVMSourceArrayLikeType resolvedType = new LLVMSourceArrayLikeType(this.getBitSize(type), this.getAlignment(type), 0L, null);
                this.resolved.put(type, resolvedType);
                LLVMSourceType resolvedBaseType = this.resolveType(type.getElementType(0L));
                resolvedType.setBaseType(resolvedBaseType);
                resolvedType.setLength(type.getNumberOfElements());
                resolvedType.setName(() -> {
                    String content = String.format("%d x %s", type.getNumberOfElements(), resolvedBaseType.getName());
                    String aggregateFormat = type instanceof ArrayType ? "[ %s ]" : "< %s >";
                    return String.format(aggregateFormat, content);
                });
            }
            catch (Type.TypeOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void visit(VariableBitWidthType type) {
            String name = String.format("i%d", type.getBitSize());
            LLVMSourceBasicType resolvedType = new LLVMSourceBasicType(name, type.getBitSize(), this.getAlignment(type), 0L, LLVMSourceBasicType.Kind.SIGNED, null);
            this.resolved.put(type, resolvedType);
        }

        @Override
        public void visit(VoidType type) {
            this.resolved.put(type, LLVMSourceType.VOID);
        }

        @Override
        public void visit(OpaqueType type) {
            try {
                LLVMSourceStructLikeType resolvedType = new LLVMSourceStructLikeType(type.getName(), this.getBitSize(type), this.getAlignment(type), 0L, null);
                this.resolved.put(type, resolvedType);
            }
            catch (Type.TypeOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        private long getBitSize(Type type) throws Type.TypeOverflowException {
            long byteSize = type.getSize(this.dataLayout);
            return Type.multiplyUnsignedExact(byteSize, 8L);
        }

        private long getAlignment(Type type) {
            return type.getAlignment(this.dataLayout);
        }
    }
}

