/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.value;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.NodeInterface;
import java.math.BigInteger;

public interface LLVMDebugValue {
    public static final String UNAVAILABLE_VALUE = "<unavailable>";
    public static final LLVMDebugValue UNAVAILABLE = new LLVMDebugValue(){

        @Override
        public String describeValue(long bitOffset, int bitSize) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object cannotInterpret(String intendedType, long bitOffset, int bitSize) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object unavailable(long bitOffset, int bitSize) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return false;
        }

        @Override
        public Object readBoolean(long bitOffset) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object readFloat(long bitOffset) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object readDouble(long bitOffset) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object read80BitFloat(long bitOffset) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object readAddress(long bitOffset) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object readUnknown(long bitOffset, int bitSize) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object computeAddress(long bitOffset) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            return LLVMDebugValue.UNAVAILABLE_VALUE;
        }

        @Override
        public LLVMDebugValue dereferencePointer(long bitOffset) {
            return null;
        }

        @Override
        public boolean isInteropValue() {
            return false;
        }

        @Override
        public Object asInteropValue() {
            return null;
        }
    };

    @CompilerDirectives.TruffleBoundary
    public static String toHexString(BigInteger value) {
        byte[] bytes = value.toByteArray();
        StringBuilder builder = new StringBuilder(bytes.length * 2 + 2);
        builder.append("0x");
        for (byte b : bytes) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public String describeValue(long var1, int var3);

    @CompilerDirectives.TruffleBoundary
    default public Object cannotInterpret(String intendedType, long bitOffset, int bitSize) {
        return String.format("<cannot interpret as %s: %s>", intendedType, this.describeValue(bitOffset, bitSize));
    }

    @CompilerDirectives.TruffleBoundary
    default public Object unavailable(long bitOffset, int bitSize) {
        return String.format("<unavailable: %s>", this.describeValue(bitOffset, bitSize));
    }

    public boolean canRead(long var1, int var3);

    public Object readBoolean(long var1);

    public Object readFloat(long var1);

    public Object readDouble(long var1);

    public Object read80BitFloat(long var1);

    public Object readAddress(long var1);

    public Object readUnknown(long var1, int var3);

    public Object computeAddress(long var1);

    public Object readBigInteger(long var1, int var3, boolean var4);

    default public boolean isAlwaysSafeToDereference(long bitOffset) {
        return false;
    }

    public LLVMDebugValue dereferencePointer(long var1);

    public boolean isInteropValue();

    public Object asInteropValue();

    default public boolean isManagedPointer() {
        return false;
    }

    default public Object getManagedPointerBase() {
        return null;
    }

    default public long getManagedPointerOffset() {
        return 0L;
    }

    public static interface Builder
    extends NodeInterface {
        public LLVMDebugValue build(Object var1);
    }
}

