/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr;

import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprNodeFactory;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr.DebugExpressionLexer;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr.DebugExpressionParser;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebuggerScopeFactory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.Collection;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class DebugExprParser {
    private final DebugExpressionParser parser;
    private final DebugExpressionLexer lexer;
    private final String asmSnippet;

    public DebugExprParser(TruffleLanguage.InlineParsingRequest request, Object globalScope, LLVMContext context) {
        this.asmSnippet = request.getSource().getCharacters().toString();
        this.lexer = new DebugExpressionLexer(CharStreams.fromString(this.asmSnippet));
        this.parser = new DebugExpressionParser(new CommonTokenStream(this.lexer));
        Collection<Scope> scopes = LLVMDebuggerScopeFactory.createSourceLevelScope(request.getLocation(), (Frame)request.getFrame(), context);
        DebugExprNodeFactory nodeFactory = DebugExprNodeFactory.create(scopes, globalScope);
        this.parser.setNodeFactory(nodeFactory);
    }

    public LLVMExpressionNode parse() throws DebugExprException {
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
        BailoutErrorListener listener = new BailoutErrorListener(this.asmSnippet);
        this.lexer.addErrorListener(listener);
        this.parser.addErrorListener(listener);
        this.parser.debugExpr();
        LLVMExpressionNode root = this.parser.GetASTRoot();
        if (this.parser.getNumberOfSyntaxErrors() == 0) {
            return root;
        }
        throw DebugExprException.create(root, listener.toString().replace("\n", "").replace("\r", ""), new Object[0]);
    }

    private static final class BailoutErrorListener
    extends BaseErrorListener {
        private final String snippet;

        BailoutErrorListener(String snippet) {
            this.snippet = snippet;
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            String location = "-- line " + line + " col " + (charPositionInLine + 1) + ": ";
            throw DebugExprException.create(null, "Debug Expression error in %s:\n%s%s", this.snippet, location, msg);
        }
    }
}

