/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public abstract class DebugExprTypeofNode
extends LLVMExpressionNode {
    private final String name;
    private final Iterable<Scope> scopes;

    public DebugExprTypeofNode(String name, Iterable<?> scopes) {
        this.name = name;
        this.scopes = scopes;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    public LLVMSourceType getLLVMSourceType() {
        InteropLibrary library = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        for (Scope scope : this.scopes) {
            Object vars = scope.getVariables();
            try {
                if (!library.isMemberReadable(vars, this.name)) continue;
                Object member = library.readMember(vars, this.name);
                LLVMDebuggerValue ldv = (LLVMDebuggerValue)member;
                Object metaObj = ldv.resolveMetaObject();
                return (LLVMSourceType)metaObj;
            }
            catch (ClassCastException e) {
                throw DebugExprException.create(this, "\"%s\" cannot be casted to a LLVMDebuggerValue", this.name);
            }
            catch (UnsupportedMessageException e) {
                throw DebugExprException.symbolNotFound(this, this.name, null);
            }
            catch (UnknownIdentifierException e) {
                throw DebugExprException.symbolNotFound(this, e.getUnknownIdentifier(), null);
            }
        }
        return LLVMSourceType.UNKNOWN;
    }

    public DebugExprType getType() {
        return DebugExprType.getTypeFromSymbolTableMetaObject(this.getLLVMSourceType());
    }

    public String getName() {
        return this.name;
    }
}

