/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.MemberAccessible;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourcePointerType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import org.graalvm.collections.Pair;

public abstract class DebugExprDereferenceNode
extends LLVMExpressionNode
implements MemberAccessible {
    @Node.Child
    private LLVMExpressionNode pointerNode;

    public DebugExprDereferenceNode(LLVMExpressionNode pointerNode) {
        this.pointerNode = pointerNode;
    }

    @Specialization
    public Object doDereference(VirtualFrame frame) {
        Object executedPointerNode = this.pointerNode.executeGeneric(frame);
        return this.getMemberAndType(executedPointerNode).getLeft();
    }

    @Override
    public DebugExprType getType() {
        if (this.pointerNode instanceof MemberAccessible) {
            MemberAccessible ma = (MemberAccessible)((Object)this.pointerNode);
            Object member = ma.getMember();
            return (DebugExprType)this.getMemberAndType(member).getRight();
        }
        throw DebugExprException.create(this, "member %s is not accessible", new Object[]{this.pointerNode});
    }

    @CompilerDirectives.TruffleBoundary
    private Pair<Object, DebugExprType> getMemberAndType(Object executedPointerNode) {
        if (executedPointerNode == null) {
            throw DebugExprException.create(this, "debugObject to dereference is null", new Object[0]);
        }
        try {
            LLVMDebuggerValue llvmDebuggerValue = (LLVMDebuggerValue)executedPointerNode;
            Object metaObj = llvmDebuggerValue.resolveMetaObject();
            DebugExprType pointerType = DebugExprType.getTypeFromSymbolTableMetaObject(metaObj);
            if (!pointerType.isPointer()) {
                throw DebugExprException.create(this, llvmDebuggerValue + " is no pointer", new Object[0]);
            }
            LLVMSourcePointerType llvmSourcePointerType = (LLVMSourcePointerType)metaObj;
            LLVMSourceType llvmSourceType = llvmSourcePointerType.getBaseType();
            LLVMDebugObject llvmPointerObject = (LLVMDebugObject)executedPointerNode;
            Object llvmPointerValue = llvmPointerObject.getValue();
            LLVMDebugValue.Builder builder = CommonNodeFactory.createDebugDeclarationBuilder();
            LLVMDebugValue dereferencedValue = builder.build(llvmPointerValue);
            LLVMDebugObject llvmDebugObject = LLVMDebugObject.create(llvmSourceType, 0L, dereferencedValue, null);
            DebugExprType type = pointerType.getInnerType();
            return Pair.create((Object)type.parse(llvmDebugObject), (Object)type);
        }
        catch (ClassCastException classCastException) {
            throw DebugExprException.create(this, executedPointerNode + " cannot be casted to pointer ", new Object[0]);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getMember() {
        if (this.pointerNode instanceof MemberAccessible) {
            MemberAccessible ma = (MemberAccessible)((Object)this.pointerNode);
            Object member = ma.getMember();
            return this.getMemberAndType(member).getLeft();
        }
        throw DebugExprException.create(this, "member %s is not accessible", new Object[]{this.pointerNode});
    }
}

