/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;

@ExportLibrary(value=InteropLibrary.class)
public abstract class LLVMDebuggerValue
implements TruffleObject {
    protected static final String[] NO_KEYS = new String[0];

    protected abstract int getElementCountForDebugger();

    protected abstract String[] getKeysForDebugger();

    protected abstract Object getElementForDebugger(String var1);

    @ExportMessage
    public final boolean hasMembers() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public Object resolveMetaObject() {
        InteropLibrary debuggerInterop = (InteropLibrary)InteropLibrary.getFactory().getUncached((Object)this);
        try {
            return debuggerInterop.hasMetaObject((Object)this) ? debuggerInterop.getMetaObject((Object)this) : null;
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected unsupported message.", e);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public final Object getMembers(boolean includeInternal) {
        if (this.getElementCountForDebugger() == 0) {
            return SubElements.EMPTY;
        }
        String[] keys = this.getKeysForDebugger();
        return new SubElements(keys);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public final boolean isMemberReadable(String key) {
        Object element = this.getElementForDebugger(key);
        return element != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public final Object readMember(String key, @Cached BranchProfile exception) throws UnknownIdentifierException {
        Object element = this.getElementForDebugger(key);
        if (element != null) {
            return element;
        }
        exception.enter();
        throw UnknownIdentifierException.create((String)key);
    }

    @ExportMessage
    public final boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    public final Class<? extends TruffleLanguage<?>> getLanguage() {
        return LLVMLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public final String toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class SubElements
    implements TruffleObject {
        private static final SubElements EMPTY = new SubElements(NO_KEYS);
        private final String[] keys;

        SubElements(String[] keys) {
            this.keys = keys;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.keys.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return Long.compareUnsigned(idx, this.keys.length) < 0;
        }

        @ExportMessage
        String readArrayElement(long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            if (this.isArrayElementReadable(idx)) {
                return this.keys[(int)idx];
            }
            exception.enter();
            throw InvalidArrayIndexException.create((long)idx);
        }
    }
}

