/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ToolchainImpl
implements Toolchain {
    private final ToolchainConfig toolchainConfig;
    private final LLVMLanguage language;

    public ToolchainImpl(ToolchainConfig toolchainConfig, LLVMLanguage language) {
        this.toolchainConfig = toolchainConfig;
        this.language = language;
    }

    public TruffleFile getToolPath(String tool) {
        if (this.toolchainConfig == null) {
            return null;
        }
        TruffleFile binPrefix = this.getWrappersRoot().resolve("bin");
        switch (tool) {
            case "PATH": {
                return binPrefix;
            }
            case "CC": {
                return binPrefix.resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-clang");
            }
            case "CXX": {
                if (!this.toolchainConfig.enableCXX()) {
                    return null;
                }
                return binPrefix.resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-clang++");
            }
            case "LD": {
                return binPrefix.resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-ld");
            }
            case "AR": 
            case "NM": 
            case "OBJCOPY": 
            case "OBJDUMP": 
            case "RANLIB": 
            case "READELF": 
            case "READOBJ": 
            case "STRIP": {
                return binPrefix.resolve(tool.toLowerCase());
            }
        }
        return null;
    }

    public List<TruffleFile> getPaths(String pathName) {
        if (this.toolchainConfig == null) {
            return null;
        }
        switch (pathName) {
            case "PATH": {
                return Collections.unmodifiableList(Arrays.asList(this.getWrappersRoot().resolve("bin")));
            }
            case "LD_LIBRARY_PATH": {
                return Collections.unmodifiableList(Arrays.asList(this.getSysroot().resolve("lib")));
            }
        }
        return null;
    }

    private TruffleFile getWrappersRoot() {
        TruffleLanguage.Env env = LLVMLanguage.getContext().getEnv();
        String toolchainRoot = this.toolchainConfig.getToolchainRootOverride();
        return toolchainRoot != null ? env.getInternalTruffleFile(toolchainRoot) : this.getSysroot();
    }

    private TruffleFile getSysroot() {
        TruffleLanguage.Env env = LLVMLanguage.getContext().getEnv();
        return env.getInternalTruffleFile(this.language.getLLVMLanguageHome()).resolve(this.toolchainConfig.getToolchainSubdir());
    }

    public String getIdentifier() {
        if (this.toolchainConfig == null) {
            return null;
        }
        return this.toolchainConfig.getToolchainSubdir();
    }

    public String toString() {
        return this.toolchainConfig.getClass().getSimpleName();
    }
}

