/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SulongStackTrace {
    private final ArrayList<Element> trace = new ArrayList();
    private final String summary;

    public SulongStackTrace(String summary) {
        this.summary = summary;
    }

    public void addStackTraceElement(String sourceFunctionName, LLVMSourceLocation sourceLocation, String irFunctionName, String irSourceName, String irBlock) {
        this.trace.add(new Element(sourceFunctionName, sourceLocation, irFunctionName, irSourceName, irBlock));
    }

    public void addStackTraceElement(String irFunctionName, String irSourceName, String irBlock) {
        this.trace.add(new Element(irFunctionName, irSourceName, irBlock));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.summary);
        sb.append("\n\n");
        sb.append("C stack trace:\n");
        for (Element e : this.trace) {
            e.appendToStackTrace(sb);
        }
        return sb.toString();
    }

    public List<Element> getTrace() {
        return Collections.unmodifiableList(this.trace);
    }

    public static final class Element {
        private final String sourceFunctionName;
        private final LLVMSourceLocation sourceLocation;
        private final String irFunctionName;
        private final String irBlock;
        private final String irSourceName;

        Element(String sourceFunctionName, LLVMSourceLocation sourceLocation, String irFunctionName, String llvmirSourceName, String irBlock) {
            this.sourceFunctionName = sourceFunctionName;
            this.irFunctionName = irFunctionName;
            this.irBlock = irBlock;
            this.sourceLocation = sourceLocation;
            this.irSourceName = llvmirSourceName;
        }

        Element(String irFunctionName, String llvmirSourceName, String irBlock) {
            this(null, null, irFunctionName, llvmirSourceName, irBlock);
        }

        void appendToStackTrace(StringBuilder builder) {
            builder.append("\t ");
            boolean encloseIRScope = false;
            if (this.sourceFunctionName != null) {
                builder.append(this.sourceFunctionName);
                encloseIRScope = true;
            } else if (this.sourceLocation != null) {
                builder.append("<unknown>");
            }
            if (this.sourceLocation != null) {
                builder.append(" in ");
                builder.append(this.sourceLocation.describeLocation());
                encloseIRScope = true;
            }
            if (encloseIRScope) {
                builder.append(" (");
            }
            builder.append("LLVM IR Function ").append(this.irFunctionName);
            if (this.irSourceName != null) {
                builder.append(" in ").append(this.irSourceName);
            }
            if (this.irBlock != null) {
                builder.append(" in Block {").append(this.irBlock).append('}');
            }
            if (encloseIRScope) {
                builder.append(')');
            }
            builder.append('\n');
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendToStackTrace(sb);
            return sb.toString();
        }
    }
}

