/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.options.TargetStream;
import java.io.PrintStream;
import java.util.List;

public abstract class LibraryLocator {
    @CompilerDirectives.TruffleBoundary
    public final TruffleFile locate(LLVMContext context, String lib, Object reason) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, "\n");
        }
        LibraryLocator.traceFind(context, lib, reason);
        return this.locateLibrary(context, lib, reason);
    }

    protected abstract TruffleFile locateLibrary(LLVMContext var1, String var2, Object var3);

    public static void traceFind(LLVMContext context, Object lib, Object reason) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, "find external library=%s; needed by %s\n", lib, reason);
        }
    }

    public static void traceTry(LLVMContext context, Object file) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, "  trying file=%s\n", file);
        }
    }

    public static void traceDelegateNative(LLVMContext context, Object file) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, "  delegating to native=%s\n", file);
        }
    }

    public static void traceLoadNative(LLVMContext context, Object file) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, "load library natively=%s\n", file);
        }
    }

    public static void traceSearchPath(LLVMContext context, List<?> paths) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, " search path=%s\n", paths);
        }
    }

    public static void traceSearchPath(LLVMContext context, List<?> paths, Object reason) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, " search path=%s (local path from %s)\n", paths, reason);
        }
    }

    public static void traceParseBitcode(LLVMContext context, Object path) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, "parse bitcode=%s\n", path);
        }
    }

    public static void traceAlreadyLoaded(LLVMContext context, Object path) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, "library already located: %s\n", path);
        }
    }

    public static void traceStaticInits(LLVMContext context, Object prefix, Object module) {
        LibraryLocator.traceStaticInits(context, prefix, module, "");
    }

    public static void traceStaticInits(LLVMContext context, Object prefix, Object module, Object details) {
        if (context != null && context.loaderTraceStream() != null) {
            LibraryLocator.traceLoader(context, "calling %s: %s %s\n", prefix, module, details);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceLoader(LLVMContext context, String str) {
        TargetStream stream = context.loaderTraceStream();
        LibraryLocator.printPrefix(stream, context);
        stream.print(str);
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceLoader(LLVMContext context, String format, Object arg0) {
        TargetStream stream = context.loaderTraceStream();
        LibraryLocator.printPrefix(stream, context);
        stream.printf(format, arg0);
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceLoader(LLVMContext context, String format, Object arg0, Object arg1) {
        TargetStream stream = context.loaderTraceStream();
        LibraryLocator.printPrefix(stream, context);
        stream.printf(format, arg0, arg1);
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceLoader(LLVMContext context, String format, Object arg0, Object arg1, Object arg2) {
        TargetStream stream = context.loaderTraceStream();
        LibraryLocator.printPrefix(stream, context);
        stream.printf(format, arg0, arg1, arg2);
    }

    private static void printPrefix(PrintStream stream, LLVMContext context) {
        stream.printf("lli(%x): ", System.identityHashCode(context));
    }
}

