/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;

@CompilerDirectives.ValueType
public final class LLVMVarArgCompoundValue {
    private final Object addr;
    private final long size;
    private final int alignment;

    private LLVMVarArgCompoundValue(Object val, long size, int alignment) {
        this.addr = val;
        this.size = size;
        this.alignment = alignment;
    }

    public static LLVMVarArgCompoundValue create(Object val, long size, int alignment) {
        return new LLVMVarArgCompoundValue(val, size, alignment);
    }

    public Object getAddr() {
        return this.addr;
    }

    public long getSize() {
        return this.size;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue curObj = (LLVMVarArgCompoundValue)obj;
            return curObj.addr.equals(this.addr) && curObj.size == this.size && curObj.alignment == this.alignment;
        }
        return false;
    }

    public int hashCode() {
        return this.addr.hashCode() + 11 * Long.hashCode(this.size) + 23 * Integer.hashCode(this.alignment);
    }

    public String toString() {
        return String.format("%s (%d align %d)", this.getAddr(), this.getSize(), this.getAlignment());
    }
}

