/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMGetStackFromThreadNodeGen;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

@GenerateUncached
public abstract class LLVMGetStackFromThreadNode
extends LLVMNode {
    public static LLVMGetStackFromThreadNode create() {
        return LLVMGetStackFromThreadNodeGen.create();
    }

    public abstract LLVMStack executeWithTarget(LLVMThreadingStack var1, Thread var2);

    protected LLVMStack getStack(LLVMThreadingStack threadingStack, Thread cachedThread) {
        if (Thread.currentThread() == cachedThread) {
            return threadingStack.getStack();
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException();
    }

    @Specialization(limit="3", guards={"currentThread == cachedThread"}, assumptions={"singleContextAssumption()"})
    protected LLVMStack cached(LLVMThreadingStack stack, Thread currentThread, @Cached(value="currentThread") Thread cachedThread, @Cached(value="getStack(stack, cachedThread)") LLVMStack cachedStack) {
        return cachedStack;
    }

    @Specialization(replaces={"cached"})
    static LLVMStack generic(LLVMThreadingStack stack, Thread currentThread) {
        return stack.getStack();
    }
}

