/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;

public abstract class LLVMGetStackFromFrameNode
extends LLVMExpressionNode {
    @CompilerDirectives.CompilationFinal
    private LLVMStack.LLVMStackAccess stackAccess;

    protected LLVMStack.LLVMStackAccess ensureStackAccess() {
        if (this.stackAccess == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.stackAccess = ((LLVMRootNode)this.getRootNode()).getStackAccess();
        }
        return this.stackAccess;
    }

    @Specialization
    Object getStack(VirtualFrame frame) {
        return this.ensureStackAccess().executeGetStack(frame);
    }
}

