/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObjectGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMFunctionDescriptor.class)
final class LLVMFunctionDescriptorGen {
    private LLVMFunctionDescriptorGen() {
    }

    static {
        LibraryExport.register(LLVMFunctionDescriptor.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=LLVMFunctionDescriptor.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMFunctionDescriptor.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        private static final class Uncached
        extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Uncached {
            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, IndirectCallNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((LLVMFunctionDescriptor)receiver).toNative();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isMemberInvocable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object receiver, String member, Object ... arguments) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).invokeMember(member, arguments);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isInstantiable();
            }

            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return arg0Value.instantiate(arg1Value, IndirectCallNode.getUncached());
            }
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        private static final class Cached
        extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Cached {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private ExecuteDescriptorData execute_descriptor_cache;
            @Node.Child
            private ExecuteCachedData execute_cached_cache;
            @Node.Child
            private IndirectCallNode execute_polymorphic0_call_;
            @Node.Child
            private IndirectCallNode instantiateNode__call_;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @ExplodeLoop
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0) {
                        ExecuteDescriptorData s1_ = this.execute_descriptor_cache;
                        while (s1_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeDescriptor_((Object)s1_);
                                return this.executeAndSpecialize(arg0Value, arg1Value);
                            }
                            if (arg0Value == s1_.cachedSelf_) {
                                return LLVMFunctionDescriptor.Execute.doDescriptor(arg0Value, arg1Value, s1_.cachedSelf_, s1_.call_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        ExecuteCachedData s2_ = this.execute_cached_cache;
                        while (s2_ != null) {
                            if (arg0Value.getFunctionCode() == s2_.cachedFunctionCode_) {
                                return LLVMFunctionDescriptor.Execute.doCached(arg0Value, arg1Value, s2_.cachedFunctionCode_, s2_.call_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        return LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, this.execute_polymorphic0_call_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    if ((exclude & 1) == 0) {
                        Object assumption0;
                        int count1_ = 0;
                        ExecuteDescriptorData s1_ = this.execute_descriptor_cache;
                        if ((state_0 & 1) != 0) {
                            while (s1_ != null && (arg0Value != s1_.cachedSelf_ || s1_.assumption0_ != null && !Assumption.isValidAssumption((Assumption)s1_.assumption0_))) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && Assumption.isValidAssumption((Assumption)(assumption0 = LLVMFunctionDescriptor.Execute.singleContextAssumption())) && count1_ < 5) {
                            s1_ = (ExecuteDescriptorData)super.insert((Node)new ExecuteDescriptorData(this.execute_descriptor_cache));
                            s1_.cachedSelf_ = arg0Value;
                            s1_.call_ = s1_.insertAccessor(LLVMFunctionDescriptor.Execute.createCall(s1_.cachedSelf_));
                            s1_.assumption0_ = assumption0;
                            this.execute_descriptor_cache = s1_;
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            assumption0 = LLVMFunctionDescriptor.Execute.doDescriptor(arg0Value, arg1Value, s1_.cachedSelf_, s1_.call_);
                            return assumption0;
                        }
                    }
                    if ((exclude & 2) == 0) {
                        int count2_ = 0;
                        ExecuteCachedData s2_ = this.execute_cached_cache;
                        if ((state_0 & 2) != 0) {
                            while (s2_ != null && arg0Value.getFunctionCode() != s2_.cachedFunctionCode_) {
                                s2_ = s2_.next_;
                                ++count2_;
                            }
                        }
                        if (s2_ == null) {
                            LLVMFunctionCode cachedFunctionCode__ = arg0Value.getFunctionCode();
                            if (arg0Value.getFunctionCode() == cachedFunctionCode__ && count2_ < 5) {
                                s2_ = (ExecuteCachedData)super.insert((Node)new ExecuteCachedData(this.execute_cached_cache));
                                s2_.cachedFunctionCode_ = cachedFunctionCode__;
                                s2_.call_ = s2_.insertAccessor(LLVMFunctionDescriptor.Execute.createCall(arg0Value));
                                this.execute_cached_cache = s2_;
                                this.exclude_ = exclude |= 1;
                                this.execute_descriptor_cache = null;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                            }
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = LLVMFunctionDescriptor.Execute.doCached(arg0Value, arg1Value, s2_.cachedFunctionCode_, s2_.call_);
                            return object;
                        }
                    }
                    this.execute_polymorphic0_call_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                    this.exclude_ = exclude |= 3;
                    this.execute_descriptor_cache = null;
                    this.execute_cached_cache = null;
                    state_0 &= 0xFFFFFFFC;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, this.execute_polymorphic0_call_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 7) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
                    ExecuteDescriptorData s1_ = this.execute_descriptor_cache;
                    ExecuteCachedData s2_ = this.execute_cached_cache;
                    if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeDescriptor_(Object s1_) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    ExecuteDescriptorData prev = null;
                    ExecuteDescriptorData cur = this.execute_descriptor_cache;
                    while (cur != null) {
                        if (cur == s1_) {
                            if (prev == null) {
                                this.execute_descriptor_cache = cur.next_;
                                this.adoptChildren();
                                break;
                            }
                            prev.next_ = cur.next_;
                            prev.adoptChildren();
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.execute_descriptor_cache == null) {
                        this.state_0_ &= 0xFFFFFFFE;
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).asPointer();
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).isPointer();
            }

            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((LLVMFunctionDescriptor)receiver).toNative();
            }

            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).isExecutable();
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).getMembers(includeInternal);
            }

            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).isMemberInvocable(member);
            }

            public Object invokeMember(Object receiver, String member, Object ... arguments) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).invokeMember(member, arguments);
            }

            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).isInstantiable();
            }

            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0) {
                    return arg0Value.instantiate(arg1Value, this.instantiateNode__call_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object instantiateNode_AndSpecialize(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    this.instantiateNode__call_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.instantiate(arg1Value, this.instantiateNode__call_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            private static final class ExecuteCachedData
            extends Node {
                @Node.Child
                ExecuteCachedData next_;
                @CompilerDirectives.CompilationFinal
                LLVMFunctionCode cachedFunctionCode_;
                @Node.Child
                DirectCallNode call_;

                ExecuteCachedData(ExecuteCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            private static final class ExecuteDescriptorData
            extends Node {
                @Node.Child
                ExecuteDescriptorData next_;
                @CompilerDirectives.CompilationFinal
                LLVMFunctionDescriptor cachedSelf_;
                @Node.Child
                DirectCallNode call_;
                @CompilerDirectives.CompilationFinal
                Assumption assumption0_;

                ExecuteDescriptorData(ExecuteDescriptorData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

