/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMFunctionDescriptor
extends LLVMInternalTruffleObject
implements Comparable<LLVMFunctionDescriptor> {
    private static final long SULONG_FUNCTION_POINTER_TAG = -4981268375154982912L;
    private final LLVMFunction llvmFunction;
    private final LLVMFunctionCode functionCode;
    @CompilerDirectives.CompilationFinal
    private Object nativeWrapper;
    @CompilerDirectives.CompilationFinal
    private long nativePointer;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static long tagSulongFunctionPointer(int id) {
        return (long)id | 0xBADEFACE00000000L;
    }

    public LLVMFunction getLLVMFunction() {
        return this.llvmFunction;
    }

    public LLVMFunctionCode getFunctionCode() {
        return this.functionCode;
    }

    public long getNativePointer() {
        return this.nativePointer;
    }

    public LLVMFunctionDescriptor(LLVMFunction llvmFunction, LLVMFunctionCode functionCode) {
        CompilerAsserts.neverPartOfCompilation();
        this.llvmFunction = llvmFunction;
        this.functionCode = functionCode;
    }

    public String toString() {
        return String.format("function@%d '%s'", this.llvmFunction.getSymbolIndex(true), this.llvmFunction.getName());
    }

    @Override
    public int compareTo(LLVMFunctionDescriptor o) {
        int otherIndex = o.llvmFunction.getSymbolIndex(true);
        int otherID = o.llvmFunction.getBitcodeID(true);
        int index = this.llvmFunction.getSymbolIndex(true);
        int id = this.llvmFunction.getBitcodeID(true);
        if (id == otherID) {
            return Long.compare(index, otherIndex);
        }
        throw new IllegalStateException("Comparing functions from different bitcode files.");
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.nativePointer;
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isPointer() {
        return this.nativeWrapper != null;
    }

    @ExportMessage
    LLVMFunctionDescriptor toNative() {
        if (this.nativeWrapper == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeWrapper = this.functionCode.getFunction().createNativeWrapper(this);
            try {
                this.nativePointer = ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asPointer(this.nativeWrapper);
            }
            catch (UnsupportedMessageException ex) {
                this.nativePointer = LLVMFunctionDescriptor.tagSulongFunctionPointer(this.llvmFunction.getSymbolIndex(true));
            }
        }
        return this;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new FunctionMembers();
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        return "bind".equals(member);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args) throws UnknownIdentifierException {
        if ("bind".equals(member)) {
            return this;
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    boolean isInstantiable() {
        return true;
    }

    @ExportMessage
    Object instantiate(Object[] arguments, @Cached.Exclusive @Cached IndirectCallNode call) {
        Object[] newArgs = new Object[arguments.length + 1];
        for (int i = 0; i < arguments.length; ++i) {
            newArgs[i + 1] = arguments[i];
        }
        return call.call(this.functionCode.getForeignConstructorCallTarget(this), newArgs);
    }

    static {
        boolean bl = $assertionsDisabled = !LLVMFunctionDescriptor.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !LLVMHandleMemoryBase.isCommonHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && LLVMHandleMemoryBase.isDerefHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class FunctionMembers
    implements TruffleObject {
        FunctionMembers() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 1L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index == 0L;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (index == 0L) {
                return "bind";
            }
            throw InvalidArrayIndexException.create((long)index);
        }
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        @Specialization(limit="5", guards={"self == cachedSelf"}, assumptions={"singleContextAssumption()"})
        static Object doDescriptor(LLVMFunctionDescriptor self, Object[] args, @Cached(value="self") LLVMFunctionDescriptor cachedSelf, @Cached(value="createCall(cachedSelf)") DirectCallNode call) {
            return call.call(args);
        }

        @Specialization(replaces={"doDescriptor"}, limit="5", guards={"self.getFunctionCode() == cachedFunctionCode"})
        static Object doCached(LLVMFunctionDescriptor self, Object[] args, @Cached(value="self.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCall(self)") DirectCallNode call) {
            return call.call(args);
        }

        @Specialization(replaces={"doCached"})
        static Object doPolymorphic(LLVMFunctionDescriptor self, Object[] args, @Cached.Exclusive @Cached IndirectCallNode call) {
            return call.call(self.getFunctionCode().getForeignCallTarget(self), args);
        }

        protected static DirectCallNode createCall(LLVMFunctionDescriptor self) {
            DirectCallNode callNode = DirectCallNode.create((CallTarget)self.getFunctionCode().getForeignCallTarget(self));
            callNode.forceInlining();
            return callNode;
        }

        protected static Assumption singleContextAssumption() {
            return LLVMLanguage.getLanguage().singleContextAssumption;
        }
    }
}

