/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class LLVMAlias
extends LLVMSymbol {
    @CompilerDirectives.CompilationFinal
    private LLVMSymbol target;

    public LLVMAlias(String name, LLVMSymbol target, boolean exported) {
        super(name, -1, -1, exported);
        this.setTarget(target);
    }

    public LLVMSymbol getTarget() {
        return this.target;
    }

    public void setTarget(LLVMSymbol value) {
        this.target = value;
        if (this.target instanceof LLVMAlias) {
            EconomicSet visited = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
            this.checkForCycle(this, (EconomicSet<LLVMAlias>)visited);
        }
    }

    @Override
    public boolean isFunction() {
        return this.target.isFunction();
    }

    @Override
    public boolean isGlobalVariable() {
        return this.target.isGlobalVariable();
    }

    @Override
    public boolean isAlias() {
        return true;
    }

    @Override
    public LLVMFunction asFunction() {
        return this.target.asFunction();
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        return this.target.asGlobalVariable();
    }

    public String toString() {
        return super.getName() + " -> " + this.target.toString();
    }

    private void checkForCycle(LLVMAlias alias, EconomicSet<LLVMAlias> visited) {
        if (visited.contains((Object)alias)) {
            throw new LLVMLinkerException("Found a cycle between the following aliases: " + visited.toString());
        }
        visited.add((Object)alias);
        if (alias.getTarget() instanceof LLVMAlias) {
            this.checkForCycle((LLVMAlias)alias.getTarget(), visited);
        }
    }

    public static LLVMSymbol resolveAlias(LLVMSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        LLVMSymbol tmp = symbol;
        while (tmp.isAlias()) {
            tmp = ((LLVMAlias)tmp).getTarget();
        }
        return tmp;
    }
}

