/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Call;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class VoidCallInstruction
extends VoidInstruction
implements Call {
    private SymbolImpl target;
    private final SymbolImpl[] arguments;
    private final AttributesCodeEntry paramAttr;

    private VoidCallInstruction(AttributesCodeEntry paramAtt, int argCount) {
        this.arguments = argCount == 0 ? NO_ARGS : new SymbolImpl[argCount];
        this.paramAttr = paramAtt;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SymbolImpl[] getArguments() {
        return this.arguments;
    }

    @Override
    public SymbolImpl getCallTarget() {
        return this.target;
    }

    @Override
    public AttributesGroup getFunctionAttributesGroup() {
        return this.paramAttr.getFunctionAttributesGroup();
    }

    @Override
    public AttributesGroup getReturnAttributesGroup() {
        return this.paramAttr.getReturnAttributesGroup();
    }

    @Override
    public AttributesGroup getParameterAttributesGroup(int idx) {
        return this.paramAttr.getParameterAttributesGroup(idx);
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.target == original) {
            this.target = replacement;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != original) continue;
            this.arguments[i] = replacement;
        }
    }

    public static VoidCallInstruction fromSymbols(IRScope scope, int targetIndex, int[] arguments, AttributesCodeEntry paramAttr) {
        VoidCallInstruction inst = new VoidCallInstruction(paramAttr, arguments.length);
        inst.target = scope.getSymbols().getForwardReferenced(targetIndex, inst);
        Call.parseArguments(scope, inst.target, inst, inst.arguments, arguments);
        return inst;
    }

    public String toString() {
        return Call.asString(this.target, this.arguments);
    }
}

