/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class StringConstant
extends AbstractConstant {
    private final byte[] value;

    public StringConstant(ArrayType type, byte[] value) {
        super(type);
        this.value = value;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ArrayType getType() {
        return (ArrayType)super.getType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("c\"");
        for (int i = 0; i < this.value.length; ++i) {
            byte b = this.value[i];
            if (b < 32 || b >= 126) {
                sb.append(String.format("\\%02X", b));
                continue;
            }
            sb.append((char)b);
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return runtime.getNodeFactory().createPrimitiveArrayLiteral(this.value, this.getType(), stackFactory);
    }

    @Override
    public void addToBuffer(Constant.Buffer buffer, LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) throws Type.TypeOverflowException {
        buffer.getBuffer().put(this.value);
    }
}

