/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class GetElementPointerConstant
extends AbstractConstant {
    private final boolean isInbounds;
    private Constant base;
    private final Constant[] indices;

    private GetElementPointerConstant(Type type, boolean isInbounds, int size) {
        super(type);
        this.isInbounds = isInbounds;
        this.indices = new Constant[size];
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getBasePointer() {
        return this.base;
    }

    public SymbolImpl[] getIndices() {
        return this.indices;
    }

    public boolean isInbounds() {
        return this.isInbounds;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.base == original) {
            this.base = (Constant)replacement;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] != original) continue;
            this.indices[i] = (Constant)replacement;
        }
    }

    public static GetElementPointerConstant fromSymbols(SymbolTable symbols, Type type, int pointer, int[] indices, boolean isInbounds) {
        GetElementPointerConstant constant = new GetElementPointerConstant(type, isInbounds, indices.length);
        constant.base = symbols.getForwardReferenced(pointer, constant);
        for (int i = 0; i < indices.length; ++i) {
            constant.indices[i] = symbols.getForwardReferenced(indices[i], constant);
        }
        return constant;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        LLVMExpressionNode[] indexNodes = new LLVMExpressionNode[this.indices.length];
        Long[] indexConstants = new Long[this.indices.length];
        Type[] indexTypes = new Type[this.indices.length];
        for (int i = this.indices.length - 1; i >= 0; --i) {
            Constant indexSymbol = this.indices[i];
            indexConstants[i] = LLVMSymbolReadResolver.evaluateLongIntegerConstant(indexSymbol);
            indexTypes[i] = indexSymbol.getType();
            if (indexConstants[i] != null) continue;
            indexNodes[i] = indexSymbol.createNode(runtime, dataLayout, stackFactory);
        }
        LLVMExpressionNode currentAddress = this.base.createNode(runtime, dataLayout, stackFactory);
        Type currentType = this.base.getType();
        return CommonNodeFactory.createNestedElementPointerNode(runtime.getNodeFactory(), dataLayout, indexNodes, indexConstants, indexTypes, currentAddress, currentType);
    }
}

