/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.functions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.ValueSymbol;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.symbols.SSAValue;

public final class FunctionParameter
implements SSAValue,
ValueSymbol {
    private final Type type;
    private int frameIdentifier = -1;
    private final AttributesGroup parameterAttribute;
    private final int argIndex;
    private String name = "<anon>";

    FunctionParameter(Type type, AttributesGroup parameterAttribute, int argIndex) {
        this.type = type;
        this.parameterAttribute = parameterAttribute;
        this.argIndex = argIndex;
    }

    public int getArgIndex() {
        return this.argIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getFrameIdentifier() {
        assert (this.frameIdentifier != -1) : "uninitialized frame identifier";
        return this.frameIdentifier;
    }

    @Override
    public void setFrameIdentifier(int frameIdentifier) {
        assert (this.frameIdentifier == -1);
        this.frameIdentifier = frameIdentifier;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public AttributesGroup getParameterAttribute() {
        return this.parameterAttribute;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return String.format("Parameter %s (%s)", this.name, this.type);
    }
}

