/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model;

import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoFunctionProcessor;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.LazyFunctionParser;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalAlias;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.target.TargetDataLayout;
import com.oracle.truffle.llvm.parser.model.target.TargetInformation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceFileReference;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStaticMemberType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ModelModule {
    private static final TargetDataLayout defaultLayout = TargetDataLayout.fromString("e-i64:64-f80:128-n8:16:32:64-S128");
    private final ArrayList<Type> types = new ArrayList();
    private final ArrayList<GlobalVariable> globalVariables = new ArrayList();
    private final ArrayList<GlobalAlias> aliases = new ArrayList();
    private final ArrayList<FunctionDeclaration> declares = new ArrayList();
    private final ArrayList<FunctionDefinition> defines = new ArrayList();
    private final ArrayList<TargetInformation> targetInfo = new ArrayList();
    private final HashMap<LLVMSourceSymbol, SymbolImpl> sourceGlobals = new HashMap();
    private final HashMap<LLVMSourceStaticMemberType, SymbolImpl> sourceStaticMembers = new HashMap();
    private final HashMap<FunctionDefinition, LazyFunctionParser> lazyFunctionParsers = new HashMap();
    private TargetDataLayout targetDataLayout = defaultLayout;
    private DebugInfoFunctionProcessor functionProcessor = null;
    private final ArrayList<LLVMSourceFileReference> sourceFiles = new ArrayList();

    public void setTargetDataLayout(TargetDataLayout layout) {
        this.targetDataLayout = layout;
    }

    public TargetDataLayout getTargetDataLayout() {
        return this.targetDataLayout;
    }

    public void addFunctionDeclaration(FunctionDeclaration declaration) {
        this.declares.add(declaration);
    }

    public List<FunctionDeclaration> getDeclaredFunctions() {
        return this.declares;
    }

    public void addFunctionDefinition(FunctionDefinition definition) {
        this.defines.add(definition);
    }

    public List<FunctionDefinition> getDefinedFunctions() {
        return this.defines;
    }

    public void addFunctionParser(FunctionDefinition definition, LazyFunctionParser parser) {
        this.lazyFunctionParsers.put(definition, parser);
    }

    public LazyFunctionParser getFunctionParser(FunctionDefinition functionDefinition) {
        return this.lazyFunctionParsers.get(functionDefinition);
    }

    public void addGlobalType(Type type) {
        this.types.add(type);
    }

    public void addGlobalVariable(GlobalVariable global) {
        this.globalVariables.add(global);
    }

    public void addAlias(GlobalAlias alias) {
        this.aliases.add(alias);
    }

    public void addTargetInformation(TargetInformation info) {
        this.targetInfo.add(info);
    }

    public List<GlobalVariable> getGlobalVariables() {
        return this.globalVariables;
    }

    public List<GlobalAlias> getAliases() {
        return this.aliases;
    }

    public Map<LLVMSourceSymbol, SymbolImpl> getSourceGlobals() {
        return this.sourceGlobals;
    }

    public Map<LLVMSourceStaticMemberType, SymbolImpl> getSourceStaticMembers() {
        return this.sourceStaticMembers;
    }

    public DebugInfoFunctionProcessor getFunctionProcessor() {
        return this.functionProcessor;
    }

    public void setFunctionProcessor(DebugInfoFunctionProcessor functionProcessor) {
        this.functionProcessor = functionProcessor;
    }

    public String toString() {
        return String.format("Model (%d defines, %d declares, %d global variables, %d aliases, %d types)", this.defines.size(), this.declares.size(), this.globalVariables.size(), this.aliases.size(), this.types.size());
    }

    public void addSourceFileReference(LLVMSourceFileReference sourceFile) {
        this.sourceFiles.add(sourceFile);
    }

    public ArrayList<LLVMSourceFileReference> getSourceFileReferences() {
        return this.sourceFiles;
    }
}

