/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model;

import com.oracle.truffle.llvm.parser.ValueList;
import com.oracle.truffle.llvm.parser.metadata.MDAttachment;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.List;

public final class IRScope {
    private static final int GLOBAL_SCOPE_START = -1;
    private final SymbolTable symbols = new SymbolTable();
    private final List<Type> valueTypes = new ArrayList<Type>();
    private final List<Instruction> instructions = new ArrayList<Instruction>();
    private final MetadataValueList metadata = new MetadataValueList();
    private FunctionDefinition currentFunction = null;
    private int valueTypesScopeStart = -1;

    public void addSymbol(SymbolImpl symbol, Type type) {
        this.symbols.add(symbol);
        this.valueTypes.add(type);
    }

    public boolean isValueForwardRef(long index) {
        return index >= (long)this.valueTypes.size();
    }

    public int getNextValueIndex() {
        return this.valueTypes.size();
    }

    public Type getValueType(int i) {
        if (i < this.valueTypes.size()) {
            return this.valueTypes.get(i);
        }
        return null;
    }

    public void addInstruction(Instruction ins) {
        this.instructions.add(ins);
    }

    public void nameSymbol(int index, String argName) {
        this.symbols.nameSymbol(index, argName);
    }

    public SymbolTable getSymbols() {
        return this.symbols;
    }

    public void nameBlock(int index, String name) {
        if (this.currentFunction != null) {
            this.currentFunction.nameBlock(index, name);
        }
    }

    public void startLocalScope(FunctionDefinition function) {
        this.currentFunction = function;
        this.metadata.startScope();
        this.symbols.startScope();
        this.valueTypesScopeStart = this.valueTypes.size();
        this.instructions.clear();
    }

    public void exitLocalScope() {
        this.metadata.endScope();
        this.symbols.endScope();
        ValueList.dropLocalScope(this.valueTypesScopeStart, this.valueTypes);
        this.valueTypesScopeStart = -1;
        this.instructions.clear();
    }

    public MetadataValueList getMetadata() {
        return this.metadata;
    }

    public void attachInstructionMetadata(int index, MDAttachment attachment) {
        if (index < this.instructions.size()) {
            this.instructions.get(index).attachMetadata(attachment);
        }
    }

    public void attachGlobalMetadata(int index, MDAttachment attachment) {
        this.symbols.attachMetadata(index, attachment);
    }

    public void attachFunctionMetadata(MDAttachment attachment) {
        if (this.currentFunction != null) {
            this.currentFunction.attachMetadata(attachment);
        }
    }
}

