/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.parser.metadata.Flags;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDBasicType;
import com.oracle.truffle.llvm.parser.metadata.MDCompositeType;
import com.oracle.truffle.llvm.parser.metadata.MDDerivedType;
import com.oracle.truffle.llvm.parser.metadata.MDEnumerator;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariableExpression;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDNode;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MDSubprogram;
import com.oracle.truffle.llvm.parser.metadata.MDSubrange;
import com.oracle.truffle.llvm.parser.metadata.MDSubroutine;
import com.oracle.truffle.llvm.parser.metadata.MDType;
import com.oracle.truffle.llvm.parser.metadata.MDValue;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DIScopeBuilder;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.MDNameExtractor;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceArrayLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceBasicType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceClassLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceDecoratorType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceEnumLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourcePointerType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStaticMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStructLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

final class DITypeExtractor
implements MetadataVisitor {
    private static final String COUNT_NAME = "<count>";
    private final Map<MDBaseNode, LLVMSourceType> parsedTypes = new HashMap<MDBaseNode, LLVMSourceType>();
    private final Map<LLVMSourceStaticMemberType, SymbolImpl> staticMembers;
    private final DIScopeBuilder scopeBuilder;
    private final MetadataValueList metadata;

    LLVMSourceType parseType(MDBaseNode mdType) {
        if (mdType == null || mdType == MDVoidNode.INSTANCE) {
            return null;
        }
        return this.resolve(mdType);
    }

    DITypeExtractor(DIScopeBuilder scopeBuilder, MetadataValueList metadata, Map<LLVMSourceStaticMemberType, SymbolImpl> staticMembers) {
        this.scopeBuilder = scopeBuilder;
        this.metadata = metadata;
        this.staticMembers = staticMembers;
    }

    @Override
    public void defaultAction(MDBaseNode md) {
        this.parsedTypes.put(md, LLVMSourceType.UNKNOWN);
    }

    private LLVMSourceType resolve(MDBaseNode node, LLVMSourceType defaultValue) {
        LLVMSourceType resolved = this.resolve(node);
        return resolved != LLVMSourceType.UNKNOWN ? resolved : defaultValue;
    }

    private LLVMSourceType resolve(MDBaseNode node) {
        LLVMSourceType parsedType = this.parsedTypes.get(node);
        if (parsedType != null) {
            return parsedType;
        }
        node.accept(this);
        parsedType = this.parsedTypes.get(node);
        return parsedType != null ? parsedType : LLVMSourceType.UNKNOWN;
    }

    @Override
    public void visit(MDBasicType mdType) {
        LLVMSourceBasicType.Kind kind;
        String name = MDNameExtractor.getName(mdType.getName());
        long size = mdType.getSize();
        long align = mdType.getAlign();
        long offset = mdType.getOffset();
        switch (mdType.getEncoding()) {
            case DW_ATE_ADDRESS: {
                kind = LLVMSourceBasicType.Kind.ADDRESS;
                break;
            }
            case DW_ATE_BOOLEAN: {
                kind = LLVMSourceBasicType.Kind.BOOLEAN;
                break;
            }
            case DW_ATE_FLOAT: {
                kind = LLVMSourceBasicType.Kind.FLOATING;
                break;
            }
            case DW_ATE_SIGNED: {
                kind = LLVMSourceBasicType.Kind.SIGNED;
                break;
            }
            case DW_ATE_SIGNED_CHAR: {
                kind = LLVMSourceBasicType.Kind.SIGNED_CHAR;
                break;
            }
            case DW_ATE_UNSIGNED: {
                kind = LLVMSourceBasicType.Kind.UNSIGNED;
                break;
            }
            case DW_ATE_UNSIGNED_CHAR: {
                kind = LLVMSourceBasicType.Kind.UNSIGNED_CHAR;
                break;
            }
            default: {
                kind = LLVMSourceBasicType.Kind.UNKNOWN;
            }
        }
        LLVMSourceLocation location = this.scopeBuilder.buildLocation(mdType);
        LLVMSourceBasicType type = new LLVMSourceBasicType(name, size, align, offset, kind, location);
        this.parsedTypes.put(mdType, type);
    }

    @Override
    public void visit(MDCompositeType mdType) {
        long size = mdType.getSize();
        long align = mdType.getAlign();
        long offset = mdType.getOffset();
        LLVMSourceLocation location = this.scopeBuilder.buildLocation(mdType);
        switch (mdType.getTag()) {
            case DW_TAG_VECTOR_TYPE: 
            case DW_TAG_ARRAY_TYPE: {
                boolean isVector = mdType.getTag() == MDType.DwarfTag.DW_TAG_VECTOR_TYPE;
                LLVMSourceArrayLikeType type = new LLVMSourceArrayLikeType(size, align, offset, location);
                this.parsedTypes.put(mdType, type);
                LLVMSourceType baseType = this.resolve(mdType.getBaseType());
                ArrayList<LLVMSourceType> members = new ArrayList<LLVMSourceType>(1);
                this.getElements(mdType.getMembers(), members, false);
                for (int i = members.size() - 1; i > 0; --i) {
                    long length = DITypeExtractor.extractLength((LLVMSourceType)members.get(i));
                    long tmpSize = length * baseType.getSize();
                    LLVMSourceArrayLikeType tmp = new LLVMSourceArrayLikeType(tmpSize >= 0L ? tmpSize : 0L, align, 0L, location);
                    DITypeExtractor.setAggregateProperties(isVector, tmp, length, baseType);
                    baseType = tmp;
                }
                DITypeExtractor.setAggregateProperties(isVector, type, DITypeExtractor.extractLength((LLVMSourceType)members.get(0)), baseType);
                break;
            }
            case DW_TAG_CLASS_TYPE: {
                String name = MDNameExtractor.getName(mdType.getName());
                LLVMSourceClassLikeType type = new LLVMSourceClassLikeType(name, size, align, offset, location);
                this.parsedTypes.put(mdType, type);
                ArrayList<LLVMSourceType> members = new ArrayList<LLVMSourceType>();
                this.getElements(mdType.getMembers(), members, false);
                for (LLVMSourceType member : members) {
                    if (member instanceof LLVMSourceMemberType) {
                        type.addDynamicMember((LLVMSourceMemberType)member);
                        continue;
                    }
                    if (!(member instanceof LLVMSourceStaticMemberType)) continue;
                    type.addStaticMember((LLVMSourceStaticMemberType)member);
                }
                MDBaseNode mdMembers = mdType.getMembers();
                if (!(mdMembers instanceof MDNode)) break;
                MDNode elemListNode = (MDNode)mdMembers;
                for (MDBaseNode elemNode : elemListNode) {
                    if (!(elemNode instanceof MDSubprogram)) continue;
                    MDSubprogram mdSubprogram = (MDSubprogram)elemNode;
                    try {
                        String methodName = ((MDString)mdSubprogram.getName()).getString();
                        String methodLinkageName = ((MDString)mdSubprogram.getLinkageName()).getString();
                        LLVMSourceFunctionType llvmSourceFunctionType = (LLVMSourceFunctionType)this.parsedTypes.get(mdSubprogram);
                        if (llvmSourceFunctionType == null) continue;
                        type.addMethod(methodName, methodLinkageName, llvmSourceFunctionType);
                    }
                    catch (ClassCastException classCastException) {}
                }
                break;
            }
            case DW_TAG_UNION_TYPE: 
            case DW_TAG_STRUCTURE_TYPE: {
                String name = MDNameExtractor.getName(mdType.getName());
                if (mdType.getTag() == MDType.DwarfTag.DW_TAG_STRUCTURE_TYPE) {
                    name = String.format("struct %s", name);
                } else if (mdType.getTag() == MDType.DwarfTag.DW_TAG_UNION_TYPE) {
                    name = String.format("union %s", name);
                }
                LLVMSourceStructLikeType type = new LLVMSourceStructLikeType(name, size, align, offset, location);
                this.parsedTypes.put(mdType, type);
                ArrayList<LLVMSourceType> members = new ArrayList<LLVMSourceType>();
                this.getElements(mdType.getMembers(), members, false);
                for (LLVMSourceType member : members) {
                    if (member instanceof LLVMSourceMemberType) {
                        type.addDynamicMember((LLVMSourceMemberType)member);
                        continue;
                    }
                    if (!(member instanceof LLVMSourceStaticMemberType)) continue;
                    type.addStaticMember((LLVMSourceStaticMemberType)member);
                }
                break;
            }
            case DW_TAG_ENUMERATION_TYPE: {
                String name = String.format("enum %s", MDNameExtractor.getName(mdType.getName()));
                LLVMSourceEnumLikeType type = new LLVMSourceEnumLikeType(() -> name, size, align, offset, location);
                this.parsedTypes.put(mdType, type);
                ArrayList<LLVMSourceType> members = new ArrayList<LLVMSourceType>();
                this.getElements(mdType.getMembers(), members, false);
                for (LLVMSourceType member : members) {
                    type.addValue((int)member.getOffset(), member.getName());
                }
                break;
            }
            default: {
                this.parsedTypes.put(mdType, LLVMSourceType.UNKNOWN);
            }
        }
    }

    private static long extractLength(LLVMSourceType count) {
        return COUNT_NAME.equals(count.getName()) ? count.getSize() : -1L;
    }

    private static void setAggregateProperties(boolean isVector, LLVMSourceArrayLikeType aggregate, final long length, final LLVMSourceType baseType) {
        String nameFormatString;
        aggregate.setBaseType(baseType);
        if (length < 0L) {
            aggregate.setLength(0L);
            nameFormatString = isVector ? "%s<?>" : "%s[?]";
        } else {
            aggregate.setLength(length);
            nameFormatString = isVector ? "%s<%d>" : "%s[%d]";
        }
        aggregate.setName(new Supplier<String>(){

            @Override
            @CompilerDirectives.TruffleBoundary
            public String get() {
                String baseName = baseType.getName();
                if (baseName.contains(" ")) {
                    baseName = String.format("(%s)", baseName);
                }
                return String.format(nameFormatString, baseName, length);
            }
        });
    }

    @Override
    public void visit(MDSubroutine mdSubroutine) {
        ArrayList<LLVMSourceType> members = new ArrayList<LLVMSourceType>();
        LLVMSourceFunctionType type = new LLVMSourceFunctionType(members);
        this.parsedTypes.put(mdSubroutine, type);
        this.getElements(mdSubroutine.getTypes(), members, true);
    }

    @Override
    public void visit(MDDerivedType mdType) {
        long size = mdType.getSize();
        long align = mdType.getAlign();
        long offset = mdType.getOffset();
        LLVMSourceLocation location = this.scopeBuilder.buildLocation(mdType);
        switch (mdType.getTag()) {
            case DW_TAG_MEMBER: {
                if (Flags.ARTIFICIAL.isAllFlags(mdType.getFlags())) {
                    this.parsedTypes.put(mdType, LLVMSourceType.VOID);
                    break;
                }
                String name = MDNameExtractor.getName(mdType.getName());
                if (Flags.STATIC_MEMBER.isSetIn(mdType.getFlags())) {
                    LLVMSourceStaticMemberType type = new LLVMSourceStaticMemberType(name, size, align, location);
                    this.parsedTypes.put(mdType, type);
                    LLVMSourceType baseType = this.resolve(mdType.getBaseType());
                    type.setElementType(baseType);
                    if (!(mdType.getExtraData() instanceof MDValue)) break;
                    this.staticMembers.put(type, ((MDValue)mdType.getExtraData()).getValue());
                    break;
                }
                LLVMSourceMemberType type = new LLVMSourceMemberType(name, size, align, offset, location);
                this.parsedTypes.put(mdType, type);
                LLVMSourceType baseType = this.resolve(mdType.getBaseType());
                if (Flags.BITFIELD.isSetIn(mdType.getFlags()) || baseType != LLVMSourceType.UNKNOWN && baseType.getSize() != size) {
                    LLVMSourceDecoratorType decorator = new LLVMSourceDecoratorType(size, align, offset, Function.identity(), location);
                    decorator.setBaseType(baseType);
                    baseType = decorator;
                }
                type.setElementType(baseType);
                break;
            }
            case DW_TAG_REFERENCE_TYPE: 
            case DW_TAG_POINTER_TYPE: {
                boolean isSafeToDereference = Flags.OBJECT_POINTER.isSetIn(mdType.getFlags());
                boolean isReference = mdType.getTag() == MDType.DwarfTag.DW_TAG_REFERENCE_TYPE;
                LLVMSourcePointerType type = new LLVMSourcePointerType(size, align, offset, isSafeToDereference, isReference, location);
                this.parsedTypes.put(mdType, type);
                LLVMSourceType baseType = this.resolve(mdType.getBaseType(), LLVMSourceType.VOID);
                type.setBaseType(baseType);
                type.setName(() -> {
                    String sym;
                    String baseName = baseType.getName();
                    String string = sym = isReference ? " &" : "*";
                    if (!baseType.isPointer() && baseName.contains(" ")) {
                        return String.format("(%s)%s", baseName, sym);
                    }
                    return String.format("%s%s", baseName, sym);
                });
                break;
            }
            case DW_TAG_VOLATILE_TYPE: 
            case DW_TAG_CONST_TYPE: 
            case DW_TAG_TYPEDEF: {
                Function<String, String> decorator;
                switch (mdType.getTag()) {
                    case DW_TAG_VOLATILE_TYPE: {
                        decorator = s -> String.format("volatile %s", s);
                        break;
                    }
                    case DW_TAG_CONST_TYPE: {
                        decorator = s -> String.format("const %s", s);
                        break;
                    }
                    case DW_TAG_TYPEDEF: {
                        String name = MDNameExtractor.getName(mdType.getName());
                        decorator = s -> name;
                        break;
                    }
                    default: {
                        decorator = Function.identity();
                    }
                }
                LLVMSourceDecoratorType type = new LLVMSourceDecoratorType(size, align, offset, decorator, location);
                this.parsedTypes.put(mdType, type);
                LLVMSourceType baseType = this.resolve(mdType.getBaseType());
                type.setBaseType(baseType);
                type.setSize(baseType.getSize());
                break;
            }
            case DW_TAG_INHERITANCE: {
                LLVMSourceMemberType type = new LLVMSourceMemberType("super", size, align, offset, location);
                this.parsedTypes.put(mdType, type);
                LLVMSourceType baseType = this.resolve(mdType.getBaseType());
                type.setElementType(baseType);
                type.setName(() -> String.format("super (%s)", baseType.getName()));
                break;
            }
            default: {
                this.parsedTypes.put(mdType, LLVMSourceType.UNKNOWN);
            }
        }
    }

    @Override
    public void visit(MDSubrange mdRange) {
        Long countValue = LLVMSymbolReadResolver.evaluateLongIntegerConstant(MDValue.getIfInstance(mdRange.getCount()));
        if (countValue == null) {
            countValue = -1L;
        }
        this.parsedTypes.put(mdRange, new IntermediaryType(() -> COUNT_NAME, countValue, 0L, 0L));
    }

    @Override
    public void visit(MDEnumerator mdEnumElement) {
        String representation = MDNameExtractor.getName(mdEnumElement.getName());
        long id = mdEnumElement.getValue();
        this.parsedTypes.put(mdEnumElement, new IntermediaryType(() -> representation, 0L, 0L, id));
    }

    @Override
    public void visit(MDNode mdTypeList) {
        for (MDBaseNode member : mdTypeList) {
            this.resolve(member);
        }
    }

    @Override
    public void visit(MDString mdString) {
        MDCompositeType referencedType = this.metadata.identifyType(mdString.getString());
        if (referencedType != null) {
            LLVMSourceType type = this.resolve(referencedType);
            this.parsedTypes.put(mdString, type);
        }
    }

    @Override
    public void visit(MDGlobalVariable mdGlobal) {
        LLVMSourceType type = this.resolve(mdGlobal.getType());
        this.parsedTypes.put(mdGlobal, type);
        if (mdGlobal.getStaticMemberDeclaration() != MDVoidNode.INSTANCE && mdGlobal.getVariable() instanceof MDValue) {
            LLVMSourceType declType = this.resolve(mdGlobal.getStaticMemberDeclaration());
            SymbolImpl symbol = ((MDValue)mdGlobal.getVariable()).getValue();
            if (declType instanceof LLVMSourceStaticMemberType) {
                this.staticMembers.put((LLVMSourceStaticMemberType)declType, symbol);
            }
        }
    }

    @Override
    public void visit(MDGlobalVariableExpression mdGlobalExpression) {
        LLVMSourceType type = this.resolve(mdGlobalExpression.getGlobalVariable());
        this.parsedTypes.put(mdGlobalExpression, type);
    }

    @Override
    public void visit(MDLocalVariable mdLocal) {
        LLVMSourceType type = this.resolve(mdLocal.getType());
        if (Flags.OBJECT_POINTER.isSetIn(mdLocal.getFlags()) && type instanceof LLVMSourcePointerType) {
            LLVMSourcePointerType oldPointer = (LLVMSourcePointerType)type;
            LLVMSourcePointerType newPointer = new LLVMSourcePointerType(oldPointer.getSize(), oldPointer.getAlign(), oldPointer.getOffset(), true, oldPointer.isReference(), type.getLocation());
            newPointer.setBaseType(oldPointer.getBaseType());
            newPointer.setName(oldPointer::getName);
            type = newPointer;
        }
        this.parsedTypes.put(mdLocal, type);
    }

    @Override
    public void visit(MDSubprogram mdSubprogram) {
        this.parsedTypes.put(mdSubprogram, this.resolve(mdSubprogram.getType()));
    }

    @Override
    public void visit(MDVoidNode md) {
        this.parsedTypes.put(md, LLVMSourceType.VOID);
    }

    private void getElements(MDBaseNode elemList, List<LLVMSourceType> elemTypes, boolean includeUnknowns) {
        if (elemList instanceof MDNode) {
            MDNode elemListNode = (MDNode)elemList;
            for (MDBaseNode elemNode : elemListNode) {
                LLVMSourceType elemType = this.resolve(elemNode);
                if (elemType == LLVMSourceType.UNKNOWN && !includeUnknowns) continue;
                elemTypes.add(elemType);
            }
        }
    }

    private static final class IntermediaryType
    extends LLVMSourceType {
        IntermediaryType(Supplier<String> nameSupplier, long size, long align, long offset) {
            super(nameSupplier, size, align, offset, null);
        }

        @Override
        public LLVMSourceType getOffset(long newOffset) {
            return this;
        }
    }
}

