/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.ValueList;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDCompositeType;
import com.oracle.truffle.llvm.parser.metadata.MDKind;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDNamedNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import java.util.ArrayList;
import java.util.HashMap;

public final class MetadataValueList
extends ValueList<MDBaseNode, MetadataVisitor> {
    private static final ValueList.PlaceholderFactory<MDBaseNode, MetadataVisitor> PLACEHOLDER_FACTORY = () -> new MDBaseNode(){

        @Override
        public void accept(MetadataVisitor visitor) {
            throw new IllegalStateException("Unresolved Forward Reference!");
        }

        @Override
        public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
            throw new IllegalStateException("Unresolved Forward Reference!");
        }

        public String toString() {
            return "Forward Referenced Metadata";
        }
    };
    private final HashMap<String, MDNamedNode> namedNodes;
    private final HashMap<String, MDCompositeType> mdTypeRegistry = new HashMap();
    private final ArrayList<MDKind> kinds;
    private final ArrayList<MDLocalVariable> locals;
    private final ArrayList<MDBaseNode> exportedScopes;
    private int nextArtificialKindId = -1;

    public MetadataValueList() {
        super(PLACEHOLDER_FACTORY);
        this.namedNodes = new HashMap();
        this.kinds = new ArrayList();
        this.locals = new ArrayList();
        this.exportedScopes = new ArrayList();
    }

    public void addKind(MDKind newKind) {
        this.kinds.add(newKind);
    }

    public void addNamedNode(MDNamedNode namedNode) {
        this.namedNodes.put(namedNode.getName(), namedNode);
    }

    public MDNamedNode getNamedNode(String name) {
        return this.namedNodes.get(name);
    }

    public MDBaseNode getNullable(long valueNumber, MDBaseNode dependent) {
        if (valueNumber == 0L) {
            return MDVoidNode.INSTANCE;
        }
        int index = (int)(valueNumber - 1L);
        return this.getForwardReferenced(index, dependent);
    }

    public MDBaseNode getNonNullable(long index, MDBaseNode dependent) {
        return this.getForwardReferenced((int)index, dependent);
    }

    @Override
    public MDBaseNode getOrNull(int index) {
        MDBaseNode node = (MDBaseNode)super.getOrNull(index);
        return node != null ? node : MDVoidNode.INSTANCE;
    }

    public MDKind getKind(long id) {
        for (MDKind kind : this.kinds) {
            if (kind.getId() != id) continue;
            return kind;
        }
        return null;
    }

    public MDKind findKind(String name) {
        for (MDKind kind : this.kinds) {
            if (!kind.getName().equals(name)) continue;
            return kind;
        }
        MDKind newKind = MDKind.create(this.nextArtificialKindId--, name);
        this.kinds.add(newKind);
        return newKind;
    }

    public MDCompositeType identifyType(String name) {
        return this.mdTypeRegistry.get(name);
    }

    public void registerType(String identifier, MDCompositeType type) {
        this.mdTypeRegistry.put(identifier, type);
    }

    public void registerLocal(MDLocalVariable mdLocal) {
        this.locals.add(mdLocal);
    }

    public void consumeLocals(MetadataVisitor visitor) {
        this.locals.forEach(l -> l.accept(visitor));
        this.locals.clear();
    }

    public void registerExportedScope(MDBaseNode scope) {
        this.exportedScopes.add(scope);
    }

    public void consumeExportedScopes(MetadataVisitor visitor) {
        this.exportedScopes.forEach(l -> l.accept(visitor));
        this.exportedScopes.clear();
    }
}

