/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;

public final class MDLocation
implements MDBaseNode {
    private final long line;
    private final long column;
    private MDBaseNode inlinedAt;
    private MDBaseNode scope;

    private MDLocation(long line, long column) {
        this.line = line;
        this.column = column;
        this.inlinedAt = MDVoidNode.INSTANCE;
        this.scope = MDVoidNode.INSTANCE;
    }

    public MDLocation(long line, long column, MDBaseNode inlinedAt, MDBaseNode scope) {
        this.line = line;
        this.column = column;
        this.inlinedAt = inlinedAt;
        this.scope = scope;
    }

    public long getLine() {
        return this.line;
    }

    public long getColumn() {
        return this.column;
    }

    public MDBaseNode getInlinedAt() {
        return this.inlinedAt;
    }

    public MDBaseNode getScope() {
        return this.scope;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.inlinedAt == oldValue) {
            this.inlinedAt = newValue;
        }
        if (this.scope == oldValue) {
            this.scope = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDLocation create38(RecordBuffer buffer, MetadataValueList md) {
        buffer.skip();
        long line = buffer.read();
        long column = buffer.read();
        MDLocation location = new MDLocation(line, column);
        location.scope = md.getNonNullable(buffer.read(), location);
        location.inlinedAt = md.getNullable(buffer.read(), location);
        return location;
    }

    public static MDLocation createFromFunctionArgs(RecordBuffer buffer, MetadataValueList md) {
        long line = buffer.read();
        long col = buffer.read();
        MDLocation location = new MDLocation(line, col);
        location.scope = md.getNullable(buffer.read(), location);
        location.inlinedAt = md.getNullable(buffer.read(), location);
        return location;
    }
}

