/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDNamedLocation;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDLexicalBlock
extends MDNamedLocation {
    private final long column;
    private static final int ARGINDEX_38_SCOPE = 1;
    private static final int ARGINDEX_38_FILE = 2;
    private static final int ARGINDEX_38_LINE = 3;
    private static final int ARGINDEX_38_COLUMN = 4;
    private static final int ARGINDEX_32_SCOPE = 1;
    private static final int ARGINDEX_32_LINE = 2;
    private static final int ARGINDEX_32_COLUMN = 3;
    private static final int ARGINDEX_32_FILE = 4;

    private MDLexicalBlock(long line, long column) {
        super(line);
        this.column = column;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public long getColumn() {
        return this.column;
    }

    public static MDLexicalBlock create38(long[] args, MetadataValueList md) {
        long line = args[3];
        long column = args[4];
        MDLexicalBlock block = new MDLexicalBlock(line, column);
        block.setScope(md.getNullable(args[1], block));
        block.setFile(md.getNullable(args[2], block));
        return block;
    }

    public static MDLexicalBlock create32(long[] args, Metadata md) {
        long line = ParseUtil.asInt(args, 2, md);
        long column = ParseUtil.asInt(args, 3, md);
        MDLexicalBlock block = new MDLexicalBlock(line, column);
        block.setScope(ParseUtil.resolveReference(args, 1, block, md));
        block.setFile(ParseUtil.resolveReference(args, 4, block, md));
        return block;
    }
}

