/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.macho;

import com.oracle.truffle.llvm.parser.macho.MachOLoadCommand;
import com.oracle.truffle.llvm.parser.macho.MachOReader;

public final class MachODylibCommand
extends MachOLoadCommand {
    private final String name;
    private final int timestamp;
    private final int currentVersion;
    private final int compatibilityVersion;

    private MachODylibCommand(int cmd, int cmdSize, String name, int timestamp, int currentVersion, int compatibilityVersion) {
        super(cmd, cmdSize);
        this.name = name;
        this.timestamp = timestamp;
        this.currentVersion = currentVersion;
        this.compatibilityVersion = compatibilityVersion;
    }

    public String getName() {
        return this.name;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public int getCompatibilityVersion() {
        return this.compatibilityVersion;
    }

    public static MachODylibCommand create(MachOReader buffer) {
        int pos = buffer.getPosition();
        int cmd = buffer.getInt();
        assert (cmd == 12);
        int cmdSize = buffer.getInt();
        int offset = buffer.getInt();
        int timestamp = buffer.getInt();
        int currentVersion = buffer.getInt();
        int compatibilityVersion = buffer.getInt();
        buffer.setPosition(pos + offset);
        String name = MachODylibCommand.getString(buffer, cmdSize - offset);
        buffer.setPosition(pos + cmdSize);
        return new MachODylibCommand(cmd, cmdSize, name, timestamp, currentVersion, compatibilityVersion);
    }
}

