/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.listeners.Types;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MDSubprogram;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;

public class MetadataSubprogramOnly
extends Metadata {
    MetadataSubprogramOnly(Types types, IRScope scope) {
        super(types, scope);
    }

    @Override
    protected void parseOpcode(RecordBuffer buffer, long[] args, int opCode) {
        MDBaseNode mdBaseNode;
        super.parseOpcode(buffer, args, opCode);
        if (opCode == 21 && (mdBaseNode = this.metadata.getOrNull(this.metadata.size() - 1)) instanceof MDSubprogram) {
            MDSubprogram mdSubprogram = (MDSubprogram)mdBaseNode;
            String linkageName = MDString.getIfInstance(mdSubprogram.getLinkageName());
            String displayName = MDString.getIfInstance(mdSubprogram.getName());
            this.scope.exitLocalScope();
            throw new MDSubprogramParsedException(linkageName, displayName);
        }
    }

    public static class MDSubprogramParsedException
    extends ControlFlowException {
        private static final long serialVersionUID = 1L;
        public final String linkageName;
        public final String displayName;

        public MDSubprogramParsedException(String linkageName, String displayName) {
            this.linkageName = linkageName;
            this.displayName = displayName;
        }
    }
}

